/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.jaxws.utils.v201502;

import com.google.api.ads.dfp.jaxws.v201502.ApiException_Exception;
import com.google.api.ads.dfp.jaxws.v201502.ExportFormat;
import com.google.api.ads.dfp.jaxws.v201502.ReportDownloadOptions;
import com.google.api.ads.dfp.jaxws.v201502.ReportJobStatus;
import com.google.api.ads.dfp.jaxws.v201502.ReportServiceInterface;
import com.google.api.ads.dfp.lib.utils.ReportCallback;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class ReportDownloader {
    public static final Charset REPORT_CHARSET = Charset.forName("UTF-8");
    public static final int SLEEP_TIMER = 30000;
    private final ReportServiceInterface reportService;
    private final long reportJobId;
    private static final Set<ExportFormat> SUPPORTED_CHARSOUCE_EXPORT_FORMATS = ImmutableSet.of((Object)((Object)ExportFormat.CSV_DUMP), (Object)((Object)ExportFormat.TSV), (Object)((Object)ExportFormat.XML));

    public ReportDownloader(ReportServiceInterface reportService, long reportJobId) {
        this.reportJobId = reportJobId;
        this.reportService = reportService;
    }

    public Thread whenReportReady(final ReportCallback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"Report callback cannot be null.");
        Thread waitThread = new Thread("ReportUtils.whenReportReady " + this.reportJobId){

            public void run() {
                try {
                    if (ReportDownloader.this.waitForReportReady()) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
                catch (ApiException_Exception e) {
                    callback.onException((Exception)e);
                }
                catch (InterruptedException interruptedException) {
                    callback.onInterruption();
                }
                catch (RuntimeException e) {
                    callback.onException((Exception)e);
                }
            }
        };
        waitThread.start();
        return waitThread;
    }

    public boolean waitForReportReady() throws InterruptedException, ApiException_Exception {
        ReportJobStatus status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        while (status == ReportJobStatus.IN_PROGRESS) {
            Thread.sleep(30000L);
            status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        }
        return status == ReportJobStatus.COMPLETED;
    }

    @Deprecated
    public void downloadReport(ExportFormat exportFormat, String fileName) throws IOException, ApiException_Exception {
        this.downloadReport(exportFormat, new FileOutputStream(fileName));
    }

    @Deprecated
    public void downloadReport(ExportFormat exportFormat, OutputStream outputStream) throws IOException, ApiException_Exception {
        ReportDownloadOptions options = new ReportDownloadOptions();
        options.setExportFormat(exportFormat);
        options.setUseGzipCompression(true);
        Resources.asByteSource((URL)this.getDownloadUrl(options)).copyTo(outputStream);
    }

    @Deprecated
    public String getReport(ExportFormat exportFormat) throws IOException, ApiException_Exception {
        ReportDownloadOptions options = new ReportDownloadOptions();
        options.setExportFormat(exportFormat);
        options.setUseGzipCompression(true);
        return this.getReportAsCharSource(options).read();
    }

    public URL getDownloadUrl(ReportDownloadOptions options) throws ApiException_Exception, MalformedURLException {
        ReportJobStatus status = this.reportService.getReportJob(this.reportJobId).getReportJobStatus();
        Preconditions.checkState((status == ReportJobStatus.COMPLETED ? 1 : 0) != 0, (Object)("Report " + this.reportJobId + " must be completed before downloading. It is currently: " + (Object)((Object)status)));
        return new URL(this.reportService.getReportDownloadUrlWithOptions(this.reportJobId, options));
    }

    public CharSource getReportAsCharSource(ReportDownloadOptions options) throws IOException, ApiException_Exception {
        Preconditions.checkArgument((boolean)SUPPORTED_CHARSOUCE_EXPORT_FORMATS.contains((Object)options.getExportFormat()), (Object)("ExportFormat " + (Object)((Object)options.getExportFormat()) + " cannot be used with CharSource"));
        ByteSource byteSource = Resources.asByteSource((URL)this.getDownloadUrl(options));
        return (options.isUseGzipCompression() != false ? new GZippedByteSource(byteSource) : byteSource).asCharSource(REPORT_CHARSET);
    }

    private static class GZippedByteSource
    extends ByteSource {
        private ByteSource containedByteSource;

        public GZippedByteSource(ByteSource zippedByteSource) {
            this.containedByteSource = zippedByteSource;
        }

        public InputStream openStream() throws IOException {
            return new GZIPInputStream(this.containedByteSource.openStream());
        }
    }
}

