/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.jaxws.utils.v201208;

import com.google.api.ads.dfp.jaxws.utils.v201208.DateTimes;
import com.google.api.ads.dfp.jaxws.v201208.BooleanValue;
import com.google.api.ads.dfp.jaxws.v201208.ColumnType;
import com.google.api.ads.dfp.jaxws.v201208.DateTime;
import com.google.api.ads.dfp.jaxws.v201208.DateTimeValue;
import com.google.api.ads.dfp.jaxws.v201208.NumberValue;
import com.google.api.ads.dfp.jaxws.v201208.ResultSet;
import com.google.api.ads.dfp.jaxws.v201208.Row;
import com.google.api.ads.dfp.jaxws.v201208.TextValue;
import com.google.api.ads.dfp.jaxws.v201208.Value;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pql {
    private Pql() {
    }

    public static Value createValue(Object value) {
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value == null) {
            return new TextValue();
        }
        if (value instanceof Boolean) {
            BooleanValue booleanValue = new BooleanValue();
            booleanValue.setValue((Boolean)value);
            return booleanValue;
        }
        if (value instanceof Double || value instanceof Long || value instanceof Integer) {
            NumberValue numberValue = new NumberValue();
            numberValue.setValue(value.toString());
            return numberValue;
        }
        if (value instanceof String) {
            TextValue textValue = new TextValue();
            textValue.setValue((String)value);
            return textValue;
        }
        if (value instanceof DateTime) {
            DateTimeValue dateTimeValue = new DateTimeValue();
            dateTimeValue.setValue((DateTime)value);
            return dateTimeValue;
        }
        throw new IllegalArgumentException("Unsupported Value type [" + value.getClass() + "]");
    }

    public static String toString(Value value) {
        Object unwrappedValue = Pql.getCsvValue(value);
        if (unwrappedValue == null) {
            return "";
        }
        return unwrappedValue.toString();
    }

    public static Object getApiValue(Value value) {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof NumberValue) {
            if (((NumberValue)value).getValue() == null) {
                return null;
            }
            try {
                return NumberFormat.getInstance().parse(((NumberValue)value).getValue());
            }
            catch (ParseException parseException) {
                throw new IllegalStateException("Recieved invalid number format from API.");
            }
        }
        if (value instanceof TextValue) {
            return ((TextValue)value).getValue();
        }
        if (value instanceof DateTimeValue) {
            return ((DateTimeValue)value).getValue();
        }
        throw new IllegalArgumentException("Unsupported Value type [" + value.getClass() + "]");
    }

    public static Object getNativeValue(Value value) {
        Object apiValue = Pql.getApiValue(value);
        if (apiValue == null) {
            return null;
        }
        if (apiValue instanceof DateTime) {
            return DateTimes.toDateTime((DateTime)apiValue);
        }
        return apiValue;
    }

    public static Object getCsvValue(Value value) {
        Object apiValue = Pql.getApiValue(value);
        if (apiValue == null) {
            return null;
        }
        if (apiValue instanceof DateTime) {
            return DateTimes.toStringWithTimeZone((DateTime)apiValue);
        }
        return apiValue;
    }

    public static List<String[]> resultSetToStringArrayList(ResultSet resultSet) {
        ArrayList stringArrayList = Lists.newArrayList();
        stringArrayList.add(Pql.getColumnLabels(resultSet).toArray(new String[0]));
        if (resultSet.getRows() != null) {
            for (Row row : resultSet.getRows()) {
                try {
                    stringArrayList.add(Pql.getRowStringValues(row).toArray(new String[0]));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Cannot convert result set to string array list", e);
                }
            }
        }
        return stringArrayList;
    }

    public static String resultSetToString(ResultSet resultSet) throws IllegalAccessException {
        StringBuilder resultSetStringBuilder = new StringBuilder();
        List<String[]> resultSetStringArrayList = Pql.resultSetToStringArrayList(resultSet);
        List<Integer> maxColumnSizes = Pql.getMaxColumnSizes(resultSetStringArrayList);
        String rowTemplate = Pql.createRowTemplate(maxColumnSizes);
        String rowSeparator = Pql.createRowSeperator(maxColumnSizes);
        resultSetStringBuilder.append(rowSeparator);
        int i = 0;
        while (i < resultSetStringArrayList.size()) {
            resultSetStringBuilder.append(String.format(rowTemplate, resultSetStringArrayList.get(i))).append(rowSeparator);
            ++i;
        }
        return resultSetStringBuilder.toString();
    }

    private static String createRowTemplate(List<Integer> maxColumnSizes) {
        ArrayList columnFormatSpecifiers = Lists.newArrayList();
        for (int maxColumnSize : maxColumnSizes) {
            columnFormatSpecifiers.add("%-" + maxColumnSize + "s");
        }
        return "| " + Joiner.on((String)" | ").join((Iterable)columnFormatSpecifiers) + " |\n";
    }

    private static String createRowSeperator(List<Integer> maxColumnSizes) {
        StringBuilder rowSeparator = new StringBuilder("+");
        for (int maxColumnSize : maxColumnSizes) {
            rowSeparator.append(Strings.repeat((String)"-", (int)(maxColumnSize + 2))).append("+");
        }
        return rowSeparator.append("\n").toString();
    }

    private static List<Integer> getMaxColumnSizes(List<String[]> resultSet) {
        ArrayList maxColumnSizes = Lists.newArrayList();
        int i = 0;
        while (i < resultSet.get(0).length) {
            int maxColumnSize = -1;
            int j = 0;
            while (j < resultSet.size()) {
                if (resultSet.get(j)[i].length() > maxColumnSize) {
                    maxColumnSize = resultSet.get(j)[i].length();
                }
                ++j;
            }
            maxColumnSizes.add(maxColumnSize);
            ++i;
        }
        return maxColumnSizes;
    }

    public static List<String> getColumnLabels(ResultSet resultSet) {
        return Lists.transform((List)Lists.newArrayList(resultSet.getColumnTypes()), (Function)new Function<ColumnType, String>(){

            public String apply(ColumnType input) {
                return input.getLabelName();
            }
        });
    }

    public static List<String> getRowStringValues(Row row) {
        return Lists.transform((List)Lists.newArrayList(row.getValues()), (Function)new Function<Value, String>(){

            public String apply(Value input) {
                return Pql.toString(input);
            }
        });
    }

    public static ResultSet combineResultSets(ResultSet first, ResultSet second) {
        List secondColumns;
        Function<ColumnType, String> columnTypeToString = new Function<ColumnType, String>(){

            public String apply(ColumnType input) {
                return input.getLabelName();
            }
        };
        List firstColumns = Lists.transform((List)Lists.newArrayList(first.getColumnTypes()), (Function)columnTypeToString);
        if (!firstColumns.equals(secondColumns = Lists.transform((List)Lists.newArrayList(second.getColumnTypes()), (Function)columnTypeToString))) {
            throw new IllegalArgumentException(String.format("First result set columns [%s] do not match second columns [%s]", Joiner.on((String)",").join((Iterable)firstColumns), Joiner.on((String)",").join((Iterable)secondColumns)));
        }
        ArrayList combinedRows = Lists.newArrayList(first.getRows());
        if (second.getRows() != null) {
            combinedRows.addAll(Lists.newArrayList(second.getRows()));
        }
        ResultSet combinedResultSet = new ResultSet();
        combinedResultSet.getColumnTypes().addAll(first.getColumnTypes());
        combinedResultSet.getRows().addAll(combinedRows);
        return combinedResultSet;
    }
}

