/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.jaxws.utils.v201111;

import com.google.api.ads.dfp.jaxws.utils.v201111.DateTimes;
import com.google.api.ads.dfp.jaxws.v201111.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class Dates {
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    private Dates() {
    }

    public static com.google.api.ads.dfp.jaxws.v201111.Date fromString(String dateString) throws ParseException {
        return Dates.fromDate(new SimpleDateFormat(DATE_FORMAT).parse(dateString));
    }

    public static com.google.api.ads.dfp.jaxws.v201111.Date fromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        com.google.api.ads.dfp.jaxws.v201111.Date dfpDate = new com.google.api.ads.dfp.jaxws.v201111.Date();
        dfpDate.setYear(calendar.get(1));
        dfpDate.setMonth(calendar.get(2) + 1);
        dfpDate.setDay(calendar.get(5));
        return dfpDate;
    }

    public static com.google.api.ads.dfp.jaxws.v201111.Date today(String timeZoneId) {
        return DateTimes.today(timeZoneId).getDate();
    }

    public static Date toDate(com.google.api.ads.dfp.jaxws.v201111.Date date, String timeZoneId) {
        DateTime dateTime = new DateTime();
        dateTime.setDate(date);
        dateTime.setHour(0);
        dateTime.setMinute(0);
        dateTime.setSecond(0);
        dateTime.setTimeZoneID(timeZoneId);
        return DateTimes.toDate(dateTime);
    }

    public static String toString(com.google.api.ads.dfp.jaxws.v201111.Date date, String timeZoneId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        return dateFormat.format(Dates.toDate(date, timeZoneId));
    }
}

