/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TeamName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_TEAM = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/teams/{team}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String team;

    @Deprecated
    protected TeamName() {
        this.networkCode = null;
        this.team = null;
    }

    private TeamName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.team = (String)Preconditions.checkNotNull((Object)builder.getTeam());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getTeam() {
        return this.team;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TeamName of(String networkCode, String team) {
        return TeamName.newBuilder().setNetworkCode(networkCode).setTeam(team).build();
    }

    public static String format(String networkCode, String team) {
        return TeamName.newBuilder().setNetworkCode(networkCode).setTeam(team).build().toString();
    }

    public static TeamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_TEAM.validatedMatch(formattedString, "TeamName.parse: formattedString not in valid format");
        return TeamName.of((String)matchMap.get("network_code"), (String)matchMap.get("team"));
    }

    public static List<TeamName> parseList(List<String> formattedStrings) {
        ArrayList<TeamName> list = new ArrayList<TeamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TeamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TeamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TeamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_TEAM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TeamName teamName = this;
            synchronized (teamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.team != null) {
                        fieldMapBuilder.put((Object)"team", (Object)this.team);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_TEAM.instantiate(new String[]{"network_code", this.networkCode, "team", this.team});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TeamName that = (TeamName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.team, that.team);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.team);
    }

    public static class Builder {
        private String networkCode;
        private String team;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getTeam() {
            return this.team;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setTeam(String team) {
            this.team = team;
            return this;
        }

        private Builder(TeamName teamName) {
            this.networkCode = teamName.networkCode;
            this.team = teamName.team;
        }

        public TeamName build() {
            return new TeamName(this);
        }
    }
}

