/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreativeName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CREATIVE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/creatives/{creative}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String creative;

    @Deprecated
    protected CreativeName() {
        this.networkCode = null;
        this.creative = null;
    }

    private CreativeName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.creative = (String)Preconditions.checkNotNull((Object)builder.getCreative());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getCreative() {
        return this.creative;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CreativeName of(String networkCode, String creative) {
        return CreativeName.newBuilder().setNetworkCode(networkCode).setCreative(creative).build();
    }

    public static String format(String networkCode, String creative) {
        return CreativeName.newBuilder().setNetworkCode(networkCode).setCreative(creative).build().toString();
    }

    public static CreativeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CREATIVE.validatedMatch(formattedString, "CreativeName.parse: formattedString not in valid format");
        return CreativeName.of((String)matchMap.get("network_code"), (String)matchMap.get("creative"));
    }

    public static List<CreativeName> parseList(List<String> formattedStrings) {
        ArrayList<CreativeName> list = new ArrayList<CreativeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CreativeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CreativeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CreativeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CREATIVE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CreativeName creativeName = this;
            synchronized (creativeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.creative != null) {
                        fieldMapBuilder.put((Object)"creative", (Object)this.creative);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CREATIVE.instantiate(new String[]{"network_code", this.networkCode, "creative", this.creative});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CreativeName that = (CreativeName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.creative, that.creative);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.creative);
    }

    public static class Builder {
        private String networkCode;
        private String creative;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getCreative() {
            return this.creative;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setCreative(String creative) {
            this.creative = creative;
            return this;
        }

        private Builder(CreativeName creativeName) {
            this.networkCode = creativeName.networkCode;
            this.creative = creativeName.creative;
        }

        public CreativeName build() {
            return new CreativeName(this);
        }
    }
}

