/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContactName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CONTACT = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/contacts/{contact}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String contact;

    @Deprecated
    protected ContactName() {
        this.networkCode = null;
        this.contact = null;
    }

    private ContactName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.contact = (String)Preconditions.checkNotNull((Object)builder.getContact());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getContact() {
        return this.contact;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContactName of(String networkCode, String contact) {
        return ContactName.newBuilder().setNetworkCode(networkCode).setContact(contact).build();
    }

    public static String format(String networkCode, String contact) {
        return ContactName.newBuilder().setNetworkCode(networkCode).setContact(contact).build().toString();
    }

    public static ContactName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CONTACT.validatedMatch(formattedString, "ContactName.parse: formattedString not in valid format");
        return ContactName.of((String)matchMap.get("network_code"), (String)matchMap.get("contact"));
    }

    public static List<ContactName> parseList(List<String> formattedStrings) {
        ArrayList<ContactName> list = new ArrayList<ContactName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContactName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContactName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContactName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CONTACT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContactName contactName = this;
            synchronized (contactName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.contact != null) {
                        fieldMapBuilder.put((Object)"contact", (Object)this.contact);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CONTACT.instantiate(new String[]{"network_code", this.networkCode, "contact", this.contact});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ContactName that = (ContactName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.contact, that.contact);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.contact);
    }

    public static class Builder {
        private String networkCode;
        private String contact;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getContact() {
            return this.contact;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setContact(String contact) {
            this.contact = contact;
            return this;
        }

        private Builder(ContactName contactName) {
            this.networkCode = contactName.networkCode;
            this.contact = contactName.contact;
        }

        public ContactName build() {
            return new ContactName(this);
        }
    }
}

