/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdPartnerName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_AD_PARTNER = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/adPartners/{ad_partner}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String adPartner;

    @Deprecated
    protected AdPartnerName() {
        this.networkCode = null;
        this.adPartner = null;
    }

    private AdPartnerName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.adPartner = (String)Preconditions.checkNotNull((Object)builder.getAdPartner());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getAdPartner() {
        return this.adPartner;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdPartnerName of(String networkCode, String adPartner) {
        return AdPartnerName.newBuilder().setNetworkCode(networkCode).setAdPartner(adPartner).build();
    }

    public static String format(String networkCode, String adPartner) {
        return AdPartnerName.newBuilder().setNetworkCode(networkCode).setAdPartner(adPartner).build().toString();
    }

    public static AdPartnerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_AD_PARTNER.validatedMatch(formattedString, "AdPartnerName.parse: formattedString not in valid format");
        return AdPartnerName.of((String)matchMap.get("network_code"), (String)matchMap.get("ad_partner"));
    }

    public static List<AdPartnerName> parseList(List<String> formattedStrings) {
        ArrayList<AdPartnerName> list = new ArrayList<AdPartnerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdPartnerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdPartnerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdPartnerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_AD_PARTNER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdPartnerName adPartnerName = this;
            synchronized (adPartnerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.adPartner != null) {
                        fieldMapBuilder.put((Object)"ad_partner", (Object)this.adPartner);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_AD_PARTNER.instantiate(new String[]{"network_code", this.networkCode, "ad_partner", this.adPartner});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdPartnerName that = (AdPartnerName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.adPartner, that.adPartner);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.adPartner);
    }

    public static class Builder {
        private String networkCode;
        private String adPartner;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getAdPartner() {
            return this.adPartner;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setAdPartner(String adPartner) {
            this.adPartner = adPartner;
            return this;
        }

        private Builder(AdPartnerName adPartnerName) {
            this.networkCode = adPartnerName.networkCode;
            this.adPartner = adPartnerName.adPartner;
        }

        public AdPartnerName build() {
            return new AdPartnerName(this);
        }
    }
}

