/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PlacementName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_PLACEMENT = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/placements/{placement}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String placement;

    @Deprecated
    protected PlacementName() {
        this.networkCode = null;
        this.placement = null;
    }

    private PlacementName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.placement = (String)Preconditions.checkNotNull((Object)builder.getPlacement());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getPlacement() {
        return this.placement;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PlacementName of(String networkCode, String placement) {
        return PlacementName.newBuilder().setNetworkCode(networkCode).setPlacement(placement).build();
    }

    public static String format(String networkCode, String placement) {
        return PlacementName.newBuilder().setNetworkCode(networkCode).setPlacement(placement).build().toString();
    }

    public static PlacementName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_PLACEMENT.validatedMatch(formattedString, "PlacementName.parse: formattedString not in valid format");
        return PlacementName.of((String)matchMap.get("network_code"), (String)matchMap.get("placement"));
    }

    public static List<PlacementName> parseList(List<String> formattedStrings) {
        ArrayList<PlacementName> list = new ArrayList<PlacementName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PlacementName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PlacementName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PlacementName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_PLACEMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PlacementName placementName = this;
            synchronized (placementName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.placement != null) {
                        fieldMapBuilder.put((Object)"placement", (Object)this.placement);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_PLACEMENT.instantiate(new String[]{"network_code", this.networkCode, "placement", this.placement});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PlacementName that = (PlacementName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.placement, that.placement);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.placement);
    }

    public static class Builder {
        private String networkCode;
        private String placement;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getPlacement() {
            return this.placement;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setPlacement(String placement) {
            this.placement = placement;
            return this;
        }

        private Builder(PlacementName placementName) {
            this.networkCode = placementName.networkCode;
            this.placement = placementName.placement;
        }

        public PlacementName build() {
            return new PlacementName(this);
        }
    }
}

