/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomTargetingValueName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CUSTOM_TARGETING_KEY_CUSTOM_TARGETING_VALUE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/customTargetingKeys/{custom_targeting_key}/customTargetingValues/{custom_targeting_value}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String customTargetingKey;
    private final String customTargetingValue;

    @Deprecated
    protected CustomTargetingValueName() {
        this.networkCode = null;
        this.customTargetingKey = null;
        this.customTargetingValue = null;
    }

    private CustomTargetingValueName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.customTargetingKey = (String)Preconditions.checkNotNull((Object)builder.getCustomTargetingKey());
        this.customTargetingValue = (String)Preconditions.checkNotNull((Object)builder.getCustomTargetingValue());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getCustomTargetingKey() {
        return this.customTargetingKey;
    }

    public String getCustomTargetingValue() {
        return this.customTargetingValue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomTargetingValueName of(String networkCode, String customTargetingKey, String customTargetingValue) {
        return CustomTargetingValueName.newBuilder().setNetworkCode(networkCode).setCustomTargetingKey(customTargetingKey).setCustomTargetingValue(customTargetingValue).build();
    }

    public static String format(String networkCode, String customTargetingKey, String customTargetingValue) {
        return CustomTargetingValueName.newBuilder().setNetworkCode(networkCode).setCustomTargetingKey(customTargetingKey).setCustomTargetingValue(customTargetingValue).build().toString();
    }

    public static CustomTargetingValueName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CUSTOM_TARGETING_KEY_CUSTOM_TARGETING_VALUE.validatedMatch(formattedString, "CustomTargetingValueName.parse: formattedString not in valid format");
        return CustomTargetingValueName.of((String)matchMap.get("network_code"), (String)matchMap.get("custom_targeting_key"), (String)matchMap.get("custom_targeting_value"));
    }

    public static List<CustomTargetingValueName> parseList(List<String> formattedStrings) {
        ArrayList<CustomTargetingValueName> list = new ArrayList<CustomTargetingValueName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomTargetingValueName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomTargetingValueName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomTargetingValueName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CUSTOM_TARGETING_KEY_CUSTOM_TARGETING_VALUE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomTargetingValueName customTargetingValueName = this;
            synchronized (customTargetingValueName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.customTargetingKey != null) {
                        fieldMapBuilder.put((Object)"custom_targeting_key", (Object)this.customTargetingKey);
                    }
                    if (this.customTargetingValue != null) {
                        fieldMapBuilder.put((Object)"custom_targeting_value", (Object)this.customTargetingValue);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CUSTOM_TARGETING_KEY_CUSTOM_TARGETING_VALUE.instantiate(new String[]{"network_code", this.networkCode, "custom_targeting_key", this.customTargetingKey, "custom_targeting_value", this.customTargetingValue});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomTargetingValueName that = (CustomTargetingValueName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.customTargetingKey, that.customTargetingKey) && Objects.equals(this.customTargetingValue, that.customTargetingValue);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        h ^= Objects.hashCode(this.customTargetingKey);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customTargetingValue);
    }

    public static class Builder {
        private String networkCode;
        private String customTargetingKey;
        private String customTargetingValue;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getCustomTargetingKey() {
            return this.customTargetingKey;
        }

        public String getCustomTargetingValue() {
            return this.customTargetingValue;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setCustomTargetingKey(String customTargetingKey) {
            this.customTargetingKey = customTargetingKey;
            return this;
        }

        public Builder setCustomTargetingValue(String customTargetingValue) {
            this.customTargetingValue = customTargetingValue;
            return this;
        }

        private Builder(CustomTargetingValueName customTargetingValueName) {
            this.networkCode = customTargetingValueName.networkCode;
            this.customTargetingKey = customTargetingValueName.customTargetingKey;
            this.customTargetingValue = customTargetingValueName.customTargetingValue;
        }

        public CustomTargetingValueName build() {
            return new CustomTargetingValueName(this);
        }
    }
}

