/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_REPORT = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/reports/{report}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String report;

    @Deprecated
    protected ReportName() {
        this.networkCode = null;
        this.report = null;
    }

    private ReportName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.report = (String)Preconditions.checkNotNull((Object)builder.getReport());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getReport() {
        return this.report;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReportName of(String networkCode, String report) {
        return ReportName.newBuilder().setNetworkCode(networkCode).setReport(report).build();
    }

    public static String format(String networkCode, String report) {
        return ReportName.newBuilder().setNetworkCode(networkCode).setReport(report).build().toString();
    }

    public static ReportName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_REPORT.validatedMatch(formattedString, "ReportName.parse: formattedString not in valid format");
        return ReportName.of((String)matchMap.get("network_code"), (String)matchMap.get("report"));
    }

    public static List<ReportName> parseList(List<String> formattedStrings) {
        ArrayList<ReportName> list = new ArrayList<ReportName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReportName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReportName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReportName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_REPORT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReportName reportName = this;
            synchronized (reportName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.report != null) {
                        fieldMapBuilder.put((Object)"report", (Object)this.report);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_REPORT.instantiate(new String[]{"network_code", this.networkCode, "report", this.report});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReportName that = (ReportName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.report, that.report);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.report);
    }

    public static class Builder {
        private String networkCode;
        private String report;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getReport() {
            return this.report;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setReport(String report) {
            this.report = report;
            return this;
        }

        private Builder(ReportName reportName) {
            this.networkCode = reportName.networkCode;
            this.report = reportName.report;
        }

        public ReportName build() {
            return new ReportName(this);
        }
    }
}

