/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WebPropertyName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_WEB_PROPERTY = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/webProperties/{web_property}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String webProperty;

    @Deprecated
    protected WebPropertyName() {
        this.networkCode = null;
        this.webProperty = null;
    }

    private WebPropertyName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.webProperty = (String)Preconditions.checkNotNull((Object)builder.getWebProperty());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getWebProperty() {
        return this.webProperty;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WebPropertyName of(String networkCode, String webProperty) {
        return WebPropertyName.newBuilder().setNetworkCode(networkCode).setWebProperty(webProperty).build();
    }

    public static String format(String networkCode, String webProperty) {
        return WebPropertyName.newBuilder().setNetworkCode(networkCode).setWebProperty(webProperty).build().toString();
    }

    public static WebPropertyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_WEB_PROPERTY.validatedMatch(formattedString, "WebPropertyName.parse: formattedString not in valid format");
        return WebPropertyName.of((String)matchMap.get("network_code"), (String)matchMap.get("web_property"));
    }

    public static List<WebPropertyName> parseList(List<String> formattedStrings) {
        ArrayList<WebPropertyName> list = new ArrayList<WebPropertyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WebPropertyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WebPropertyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WebPropertyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_WEB_PROPERTY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WebPropertyName webPropertyName = this;
            synchronized (webPropertyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.webProperty != null) {
                        fieldMapBuilder.put((Object)"web_property", (Object)this.webProperty);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_WEB_PROPERTY.instantiate(new String[]{"network_code", this.networkCode, "web_property", this.webProperty});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WebPropertyName that = (WebPropertyName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.webProperty, that.webProperty);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.webProperty);
    }

    public static class Builder {
        private String networkCode;
        private String webProperty;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getWebProperty() {
            return this.webProperty;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setWebProperty(String webProperty) {
            this.webProperty = webProperty;
            return this;
        }

        private Builder(WebPropertyName webPropertyName) {
            this.networkCode = webPropertyName.networkCode;
            this.webProperty = webPropertyName.webProperty;
        }

        public WebPropertyName build() {
            return new WebPropertyName(this);
        }
    }
}

