/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SiteName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_SITE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/sites/{site}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String site;

    @Deprecated
    protected SiteName() {
        this.networkCode = null;
        this.site = null;
    }

    private SiteName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.site = (String)Preconditions.checkNotNull((Object)builder.getSite());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getSite() {
        return this.site;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SiteName of(String networkCode, String site) {
        return SiteName.newBuilder().setNetworkCode(networkCode).setSite(site).build();
    }

    public static String format(String networkCode, String site) {
        return SiteName.newBuilder().setNetworkCode(networkCode).setSite(site).build().toString();
    }

    public static SiteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_SITE.validatedMatch(formattedString, "SiteName.parse: formattedString not in valid format");
        return SiteName.of((String)matchMap.get("network_code"), (String)matchMap.get("site"));
    }

    public static List<SiteName> parseList(List<String> formattedStrings) {
        ArrayList<SiteName> list = new ArrayList<SiteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SiteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SiteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SiteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_SITE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SiteName siteName = this;
            synchronized (siteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.site != null) {
                        fieldMapBuilder.put((Object)"site", (Object)this.site);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_SITE.instantiate(new String[]{"network_code", this.networkCode, "site", this.site});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SiteName that = (SiteName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.site, that.site);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.site);
    }

    public static class Builder {
        private String networkCode;
        private String site;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getSite() {
            return this.site;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setSite(String site) {
            this.site = site;
            return this;
        }

        private Builder(SiteName siteName) {
            this.networkCode = siteName.networkCode;
            this.site = siteName.site;
        }

        public SiteName build() {
            return new SiteName(this);
        }
    }
}

