/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OperatingSystemVersionName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_OPERATING_SYSTEM_VERSION = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/operatingSystemVersions/{operating_system_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String operatingSystemVersion;

    @Deprecated
    protected OperatingSystemVersionName() {
        this.networkCode = null;
        this.operatingSystemVersion = null;
    }

    private OperatingSystemVersionName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.operatingSystemVersion = (String)Preconditions.checkNotNull((Object)builder.getOperatingSystemVersion());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OperatingSystemVersionName of(String networkCode, String operatingSystemVersion) {
        return OperatingSystemVersionName.newBuilder().setNetworkCode(networkCode).setOperatingSystemVersion(operatingSystemVersion).build();
    }

    public static String format(String networkCode, String operatingSystemVersion) {
        return OperatingSystemVersionName.newBuilder().setNetworkCode(networkCode).setOperatingSystemVersion(operatingSystemVersion).build().toString();
    }

    public static OperatingSystemVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_OPERATING_SYSTEM_VERSION.validatedMatch(formattedString, "OperatingSystemVersionName.parse: formattedString not in valid format");
        return OperatingSystemVersionName.of((String)matchMap.get("network_code"), (String)matchMap.get("operating_system_version"));
    }

    public static List<OperatingSystemVersionName> parseList(List<String> formattedStrings) {
        ArrayList<OperatingSystemVersionName> list = new ArrayList<OperatingSystemVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OperatingSystemVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OperatingSystemVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OperatingSystemVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_OPERATING_SYSTEM_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OperatingSystemVersionName operatingSystemVersionName = this;
            synchronized (operatingSystemVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.operatingSystemVersion != null) {
                        fieldMapBuilder.put((Object)"operating_system_version", (Object)this.operatingSystemVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_OPERATING_SYSTEM_VERSION.instantiate(new String[]{"network_code", this.networkCode, "operating_system_version", this.operatingSystemVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OperatingSystemVersionName that = (OperatingSystemVersionName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.operatingSystemVersion, that.operatingSystemVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.operatingSystemVersion);
    }

    public static class Builder {
        private String networkCode;
        private String operatingSystemVersion;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        private Builder(OperatingSystemVersionName operatingSystemVersionName) {
            this.networkCode = operatingSystemVersionName.networkCode;
            this.operatingSystemVersion = operatingSystemVersionName.operatingSystemVersion;
        }

        public OperatingSystemVersionName build() {
            return new OperatingSystemVersionName(this);
        }
    }
}

