/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MobileDeviceSubmodelName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_MOBILE_DEVICE_SUBMODEL = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/mobileDeviceSubmodels/{mobile_device_submodel}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String mobileDeviceSubmodel;

    @Deprecated
    protected MobileDeviceSubmodelName() {
        this.networkCode = null;
        this.mobileDeviceSubmodel = null;
    }

    private MobileDeviceSubmodelName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.mobileDeviceSubmodel = (String)Preconditions.checkNotNull((Object)builder.getMobileDeviceSubmodel());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getMobileDeviceSubmodel() {
        return this.mobileDeviceSubmodel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MobileDeviceSubmodelName of(String networkCode, String mobileDeviceSubmodel) {
        return MobileDeviceSubmodelName.newBuilder().setNetworkCode(networkCode).setMobileDeviceSubmodel(mobileDeviceSubmodel).build();
    }

    public static String format(String networkCode, String mobileDeviceSubmodel) {
        return MobileDeviceSubmodelName.newBuilder().setNetworkCode(networkCode).setMobileDeviceSubmodel(mobileDeviceSubmodel).build().toString();
    }

    public static MobileDeviceSubmodelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_MOBILE_DEVICE_SUBMODEL.validatedMatch(formattedString, "MobileDeviceSubmodelName.parse: formattedString not in valid format");
        return MobileDeviceSubmodelName.of((String)matchMap.get("network_code"), (String)matchMap.get("mobile_device_submodel"));
    }

    public static List<MobileDeviceSubmodelName> parseList(List<String> formattedStrings) {
        ArrayList<MobileDeviceSubmodelName> list = new ArrayList<MobileDeviceSubmodelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MobileDeviceSubmodelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MobileDeviceSubmodelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MobileDeviceSubmodelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_MOBILE_DEVICE_SUBMODEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MobileDeviceSubmodelName mobileDeviceSubmodelName = this;
            synchronized (mobileDeviceSubmodelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.mobileDeviceSubmodel != null) {
                        fieldMapBuilder.put((Object)"mobile_device_submodel", (Object)this.mobileDeviceSubmodel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_MOBILE_DEVICE_SUBMODEL.instantiate(new String[]{"network_code", this.networkCode, "mobile_device_submodel", this.mobileDeviceSubmodel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MobileDeviceSubmodelName that = (MobileDeviceSubmodelName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.mobileDeviceSubmodel, that.mobileDeviceSubmodel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.mobileDeviceSubmodel);
    }

    public static class Builder {
        private String networkCode;
        private String mobileDeviceSubmodel;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getMobileDeviceSubmodel() {
            return this.mobileDeviceSubmodel;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setMobileDeviceSubmodel(String mobileDeviceSubmodel) {
            this.mobileDeviceSubmodel = mobileDeviceSubmodel;
            return this;
        }

        private Builder(MobileDeviceSubmodelName mobileDeviceSubmodelName) {
            this.networkCode = mobileDeviceSubmodelName.networkCode;
            this.mobileDeviceSubmodel = mobileDeviceSubmodelName.mobileDeviceSubmodel;
        }

        public MobileDeviceSubmodelName build() {
            return new MobileDeviceSubmodelName(this);
        }
    }
}

