/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MobileDeviceName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_MOBILE_DEVICE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/mobileDevices/{mobile_device}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String mobileDevice;

    @Deprecated
    protected MobileDeviceName() {
        this.networkCode = null;
        this.mobileDevice = null;
    }

    private MobileDeviceName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.mobileDevice = (String)Preconditions.checkNotNull((Object)builder.getMobileDevice());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getMobileDevice() {
        return this.mobileDevice;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MobileDeviceName of(String networkCode, String mobileDevice) {
        return MobileDeviceName.newBuilder().setNetworkCode(networkCode).setMobileDevice(mobileDevice).build();
    }

    public static String format(String networkCode, String mobileDevice) {
        return MobileDeviceName.newBuilder().setNetworkCode(networkCode).setMobileDevice(mobileDevice).build().toString();
    }

    public static MobileDeviceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_MOBILE_DEVICE.validatedMatch(formattedString, "MobileDeviceName.parse: formattedString not in valid format");
        return MobileDeviceName.of((String)matchMap.get("network_code"), (String)matchMap.get("mobile_device"));
    }

    public static List<MobileDeviceName> parseList(List<String> formattedStrings) {
        ArrayList<MobileDeviceName> list = new ArrayList<MobileDeviceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MobileDeviceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MobileDeviceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MobileDeviceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_MOBILE_DEVICE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MobileDeviceName mobileDeviceName = this;
            synchronized (mobileDeviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.mobileDevice != null) {
                        fieldMapBuilder.put((Object)"mobile_device", (Object)this.mobileDevice);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_MOBILE_DEVICE.instantiate(new String[]{"network_code", this.networkCode, "mobile_device", this.mobileDevice});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MobileDeviceName that = (MobileDeviceName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.mobileDevice, that.mobileDevice);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.mobileDevice);
    }

    public static class Builder {
        private String networkCode;
        private String mobileDevice;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getMobileDevice() {
            return this.mobileDevice;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setMobileDevice(String mobileDevice) {
            this.mobileDevice = mobileDevice;
            return this;
        }

        private Builder(MobileDeviceName mobileDeviceName) {
            this.networkCode = mobileDeviceName.networkCode;
            this.mobileDevice = mobileDeviceName.mobileDevice;
        }

        public MobileDeviceName build() {
            return new MobileDeviceName(this);
        }
    }
}

