/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MobileCarrierName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_MOBILE_CARRIER = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/mobileCarriers/{mobile_carrier}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String mobileCarrier;

    @Deprecated
    protected MobileCarrierName() {
        this.networkCode = null;
        this.mobileCarrier = null;
    }

    private MobileCarrierName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.mobileCarrier = (String)Preconditions.checkNotNull((Object)builder.getMobileCarrier());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getMobileCarrier() {
        return this.mobileCarrier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MobileCarrierName of(String networkCode, String mobileCarrier) {
        return MobileCarrierName.newBuilder().setNetworkCode(networkCode).setMobileCarrier(mobileCarrier).build();
    }

    public static String format(String networkCode, String mobileCarrier) {
        return MobileCarrierName.newBuilder().setNetworkCode(networkCode).setMobileCarrier(mobileCarrier).build().toString();
    }

    public static MobileCarrierName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_MOBILE_CARRIER.validatedMatch(formattedString, "MobileCarrierName.parse: formattedString not in valid format");
        return MobileCarrierName.of((String)matchMap.get("network_code"), (String)matchMap.get("mobile_carrier"));
    }

    public static List<MobileCarrierName> parseList(List<String> formattedStrings) {
        ArrayList<MobileCarrierName> list = new ArrayList<MobileCarrierName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MobileCarrierName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MobileCarrierName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MobileCarrierName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_MOBILE_CARRIER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MobileCarrierName mobileCarrierName = this;
            synchronized (mobileCarrierName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.mobileCarrier != null) {
                        fieldMapBuilder.put((Object)"mobile_carrier", (Object)this.mobileCarrier);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_MOBILE_CARRIER.instantiate(new String[]{"network_code", this.networkCode, "mobile_carrier", this.mobileCarrier});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MobileCarrierName that = (MobileCarrierName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.mobileCarrier, that.mobileCarrier);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.mobileCarrier);
    }

    public static class Builder {
        private String networkCode;
        private String mobileCarrier;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getMobileCarrier() {
            return this.mobileCarrier;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setMobileCarrier(String mobileCarrier) {
            this.mobileCarrier = mobileCarrier;
            return this;
        }

        private Builder(MobileCarrierName mobileCarrierName) {
            this.networkCode = mobileCarrierName.networkCode;
            this.mobileCarrier = mobileCarrierName.mobileCarrier;
        }

        public MobileCarrierName build() {
            return new MobileCarrierName(this);
        }
    }
}

