/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LiveStreamEventName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_LIVE_STREAM_EVENT = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/liveStreamEvents/{live_stream_event}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String liveStreamEvent;

    @Deprecated
    protected LiveStreamEventName() {
        this.networkCode = null;
        this.liveStreamEvent = null;
    }

    private LiveStreamEventName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.liveStreamEvent = (String)Preconditions.checkNotNull((Object)builder.getLiveStreamEvent());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getLiveStreamEvent() {
        return this.liveStreamEvent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LiveStreamEventName of(String networkCode, String liveStreamEvent) {
        return LiveStreamEventName.newBuilder().setNetworkCode(networkCode).setLiveStreamEvent(liveStreamEvent).build();
    }

    public static String format(String networkCode, String liveStreamEvent) {
        return LiveStreamEventName.newBuilder().setNetworkCode(networkCode).setLiveStreamEvent(liveStreamEvent).build().toString();
    }

    public static LiveStreamEventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_LIVE_STREAM_EVENT.validatedMatch(formattedString, "LiveStreamEventName.parse: formattedString not in valid format");
        return LiveStreamEventName.of((String)matchMap.get("network_code"), (String)matchMap.get("live_stream_event"));
    }

    public static List<LiveStreamEventName> parseList(List<String> formattedStrings) {
        ArrayList<LiveStreamEventName> list = new ArrayList<LiveStreamEventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LiveStreamEventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LiveStreamEventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LiveStreamEventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_LIVE_STREAM_EVENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LiveStreamEventName liveStreamEventName = this;
            synchronized (liveStreamEventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.liveStreamEvent != null) {
                        fieldMapBuilder.put((Object)"live_stream_event", (Object)this.liveStreamEvent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_LIVE_STREAM_EVENT.instantiate(new String[]{"network_code", this.networkCode, "live_stream_event", this.liveStreamEvent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LiveStreamEventName that = (LiveStreamEventName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.liveStreamEvent, that.liveStreamEvent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.liveStreamEvent);
    }

    public static class Builder {
        private String networkCode;
        private String liveStreamEvent;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getLiveStreamEvent() {
            return this.liveStreamEvent;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setLiveStreamEvent(String liveStreamEvent) {
            this.liveStreamEvent = liveStreamEvent;
            return this;
        }

        private Builder(LiveStreamEventName liveStreamEventName) {
            this.networkCode = liveStreamEventName.networkCode;
            this.liveStreamEvent = liveStreamEventName.liveStreamEvent;
        }

        public LiveStreamEventName build() {
            return new LiveStreamEventName(this);
        }
    }
}

