/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeviceManufacturerName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_DEVICE_MANUFACTURER = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/deviceManufacturers/{device_manufacturer}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String deviceManufacturer;

    @Deprecated
    protected DeviceManufacturerName() {
        this.networkCode = null;
        this.deviceManufacturer = null;
    }

    private DeviceManufacturerName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.deviceManufacturer = (String)Preconditions.checkNotNull((Object)builder.getDeviceManufacturer());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeviceManufacturerName of(String networkCode, String deviceManufacturer) {
        return DeviceManufacturerName.newBuilder().setNetworkCode(networkCode).setDeviceManufacturer(deviceManufacturer).build();
    }

    public static String format(String networkCode, String deviceManufacturer) {
        return DeviceManufacturerName.newBuilder().setNetworkCode(networkCode).setDeviceManufacturer(deviceManufacturer).build().toString();
    }

    public static DeviceManufacturerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_DEVICE_MANUFACTURER.validatedMatch(formattedString, "DeviceManufacturerName.parse: formattedString not in valid format");
        return DeviceManufacturerName.of((String)matchMap.get("network_code"), (String)matchMap.get("device_manufacturer"));
    }

    public static List<DeviceManufacturerName> parseList(List<String> formattedStrings) {
        ArrayList<DeviceManufacturerName> list = new ArrayList<DeviceManufacturerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeviceManufacturerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeviceManufacturerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeviceManufacturerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_DEVICE_MANUFACTURER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeviceManufacturerName deviceManufacturerName = this;
            synchronized (deviceManufacturerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.deviceManufacturer != null) {
                        fieldMapBuilder.put((Object)"device_manufacturer", (Object)this.deviceManufacturer);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_DEVICE_MANUFACTURER.instantiate(new String[]{"network_code", this.networkCode, "device_manufacturer", this.deviceManufacturer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DeviceManufacturerName that = (DeviceManufacturerName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.deviceManufacturer, that.deviceManufacturer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deviceManufacturer);
    }

    public static class Builder {
        private String networkCode;
        private String deviceManufacturer;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getDeviceManufacturer() {
            return this.deviceManufacturer;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setDeviceManufacturer(String deviceManufacturer) {
            this.deviceManufacturer = deviceManufacturer;
            return this;
        }

        private Builder(DeviceManufacturerName deviceManufacturerName) {
            this.networkCode = deviceManufacturerName.networkCode;
            this.deviceManufacturer = deviceManufacturerName.deviceManufacturer;
        }

        public DeviceManufacturerName build() {
            return new DeviceManufacturerName(this);
        }
    }
}

