/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeviceCategoryName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_DEVICE_CATEGORY = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/deviceCategories/{device_category}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String deviceCategory;

    @Deprecated
    protected DeviceCategoryName() {
        this.networkCode = null;
        this.deviceCategory = null;
    }

    private DeviceCategoryName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.deviceCategory = (String)Preconditions.checkNotNull((Object)builder.getDeviceCategory());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getDeviceCategory() {
        return this.deviceCategory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeviceCategoryName of(String networkCode, String deviceCategory) {
        return DeviceCategoryName.newBuilder().setNetworkCode(networkCode).setDeviceCategory(deviceCategory).build();
    }

    public static String format(String networkCode, String deviceCategory) {
        return DeviceCategoryName.newBuilder().setNetworkCode(networkCode).setDeviceCategory(deviceCategory).build().toString();
    }

    public static DeviceCategoryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_DEVICE_CATEGORY.validatedMatch(formattedString, "DeviceCategoryName.parse: formattedString not in valid format");
        return DeviceCategoryName.of((String)matchMap.get("network_code"), (String)matchMap.get("device_category"));
    }

    public static List<DeviceCategoryName> parseList(List<String> formattedStrings) {
        ArrayList<DeviceCategoryName> list = new ArrayList<DeviceCategoryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeviceCategoryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeviceCategoryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeviceCategoryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_DEVICE_CATEGORY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeviceCategoryName deviceCategoryName = this;
            synchronized (deviceCategoryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.deviceCategory != null) {
                        fieldMapBuilder.put((Object)"device_category", (Object)this.deviceCategory);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_DEVICE_CATEGORY.instantiate(new String[]{"network_code", this.networkCode, "device_category", this.deviceCategory});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DeviceCategoryName that = (DeviceCategoryName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.deviceCategory, that.deviceCategory);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deviceCategory);
    }

    public static class Builder {
        private String networkCode;
        private String deviceCategory;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getDeviceCategory() {
            return this.deviceCategory;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setDeviceCategory(String deviceCategory) {
            this.deviceCategory = deviceCategory;
            return this;
        }

        private Builder(DeviceCategoryName deviceCategoryName) {
            this.networkCode = deviceCategoryName.networkCode;
            this.deviceCategory = deviceCategoryName.deviceCategory;
        }

        public DeviceCategoryName build() {
            return new DeviceCategoryName(this);
        }
    }
}

