/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeviceCapabilityName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_DEVICE_CAPABILITY = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/deviceCapabilities/{device_capability}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String deviceCapability;

    @Deprecated
    protected DeviceCapabilityName() {
        this.networkCode = null;
        this.deviceCapability = null;
    }

    private DeviceCapabilityName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.deviceCapability = (String)Preconditions.checkNotNull((Object)builder.getDeviceCapability());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getDeviceCapability() {
        return this.deviceCapability;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeviceCapabilityName of(String networkCode, String deviceCapability) {
        return DeviceCapabilityName.newBuilder().setNetworkCode(networkCode).setDeviceCapability(deviceCapability).build();
    }

    public static String format(String networkCode, String deviceCapability) {
        return DeviceCapabilityName.newBuilder().setNetworkCode(networkCode).setDeviceCapability(deviceCapability).build().toString();
    }

    public static DeviceCapabilityName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_DEVICE_CAPABILITY.validatedMatch(formattedString, "DeviceCapabilityName.parse: formattedString not in valid format");
        return DeviceCapabilityName.of((String)matchMap.get("network_code"), (String)matchMap.get("device_capability"));
    }

    public static List<DeviceCapabilityName> parseList(List<String> formattedStrings) {
        ArrayList<DeviceCapabilityName> list = new ArrayList<DeviceCapabilityName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeviceCapabilityName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeviceCapabilityName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeviceCapabilityName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_DEVICE_CAPABILITY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeviceCapabilityName deviceCapabilityName = this;
            synchronized (deviceCapabilityName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.deviceCapability != null) {
                        fieldMapBuilder.put((Object)"device_capability", (Object)this.deviceCapability);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_DEVICE_CAPABILITY.instantiate(new String[]{"network_code", this.networkCode, "device_capability", this.deviceCapability});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DeviceCapabilityName that = (DeviceCapabilityName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.deviceCapability, that.deviceCapability);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deviceCapability);
    }

    public static class Builder {
        private String networkCode;
        private String deviceCapability;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getDeviceCapability() {
            return this.deviceCapability;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setDeviceCapability(String deviceCapability) {
            this.deviceCapability = deviceCapability;
            return this;
        }

        private Builder(DeviceCapabilityName deviceCapabilityName) {
            this.networkCode = deviceCapabilityName.networkCode;
            this.deviceCapability = deviceCapabilityName.deviceCapability;
        }

        public DeviceCapabilityName build() {
            return new DeviceCapabilityName(this);
        }
    }
}

