/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreativeTemplateName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CREATIVE_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/creativeTemplates/{creative_template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String creativeTemplate;

    @Deprecated
    protected CreativeTemplateName() {
        this.networkCode = null;
        this.creativeTemplate = null;
    }

    private CreativeTemplateName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.creativeTemplate = (String)Preconditions.checkNotNull((Object)builder.getCreativeTemplate());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getCreativeTemplate() {
        return this.creativeTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CreativeTemplateName of(String networkCode, String creativeTemplate) {
        return CreativeTemplateName.newBuilder().setNetworkCode(networkCode).setCreativeTemplate(creativeTemplate).build();
    }

    public static String format(String networkCode, String creativeTemplate) {
        return CreativeTemplateName.newBuilder().setNetworkCode(networkCode).setCreativeTemplate(creativeTemplate).build().toString();
    }

    public static CreativeTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CREATIVE_TEMPLATE.validatedMatch(formattedString, "CreativeTemplateName.parse: formattedString not in valid format");
        return CreativeTemplateName.of((String)matchMap.get("network_code"), (String)matchMap.get("creative_template"));
    }

    public static List<CreativeTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<CreativeTemplateName> list = new ArrayList<CreativeTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CreativeTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CreativeTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CreativeTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CREATIVE_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CreativeTemplateName creativeTemplateName = this;
            synchronized (creativeTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.creativeTemplate != null) {
                        fieldMapBuilder.put((Object)"creative_template", (Object)this.creativeTemplate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CREATIVE_TEMPLATE.instantiate(new String[]{"network_code", this.networkCode, "creative_template", this.creativeTemplate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CreativeTemplateName that = (CreativeTemplateName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.creativeTemplate, that.creativeTemplate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.creativeTemplate);
    }

    public static class Builder {
        private String networkCode;
        private String creativeTemplate;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getCreativeTemplate() {
            return this.creativeTemplate;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setCreativeTemplate(String creativeTemplate) {
            this.creativeTemplate = creativeTemplate;
            return this;
        }

        private Builder(CreativeTemplateName creativeTemplateName) {
            this.networkCode = creativeTemplateName.networkCode;
            this.creativeTemplate = creativeTemplateName.creativeTemplate;
        }

        public CreativeTemplateName build() {
            return new CreativeTemplateName(this);
        }
    }
}

