/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContentName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CONTENT = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/content/{content}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String content;

    @Deprecated
    protected ContentName() {
        this.networkCode = null;
        this.content = null;
    }

    private ContentName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.content = (String)Preconditions.checkNotNull((Object)builder.getContent());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getContent() {
        return this.content;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContentName of(String networkCode, String content) {
        return ContentName.newBuilder().setNetworkCode(networkCode).setContent(content).build();
    }

    public static String format(String networkCode, String content) {
        return ContentName.newBuilder().setNetworkCode(networkCode).setContent(content).build().toString();
    }

    public static ContentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CONTENT.validatedMatch(formattedString, "ContentName.parse: formattedString not in valid format");
        return ContentName.of((String)matchMap.get("network_code"), (String)matchMap.get("content"));
    }

    public static List<ContentName> parseList(List<String> formattedStrings) {
        ArrayList<ContentName> list = new ArrayList<ContentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CONTENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContentName contentName = this;
            synchronized (contentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.content != null) {
                        fieldMapBuilder.put((Object)"content", (Object)this.content);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CONTENT.instantiate(new String[]{"network_code", this.networkCode, "content", this.content});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ContentName that = (ContentName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.content, that.content);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.content);
    }

    public static class Builder {
        private String networkCode;
        private String content;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getContent() {
            return this.content;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        private Builder(ContentName contentName) {
            this.networkCode = contentName.networkCode;
            this.content = contentName.content;
        }

        public ContentName build() {
            return new ContentName(this);
        }
    }
}

