/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContentLabelName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CONTENT_LABEL = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/contentLabels/{content_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String contentLabel;

    @Deprecated
    protected ContentLabelName() {
        this.networkCode = null;
        this.contentLabel = null;
    }

    private ContentLabelName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.contentLabel = (String)Preconditions.checkNotNull((Object)builder.getContentLabel());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getContentLabel() {
        return this.contentLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContentLabelName of(String networkCode, String contentLabel) {
        return ContentLabelName.newBuilder().setNetworkCode(networkCode).setContentLabel(contentLabel).build();
    }

    public static String format(String networkCode, String contentLabel) {
        return ContentLabelName.newBuilder().setNetworkCode(networkCode).setContentLabel(contentLabel).build().toString();
    }

    public static ContentLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CONTENT_LABEL.validatedMatch(formattedString, "ContentLabelName.parse: formattedString not in valid format");
        return ContentLabelName.of((String)matchMap.get("network_code"), (String)matchMap.get("content_label"));
    }

    public static List<ContentLabelName> parseList(List<String> formattedStrings) {
        ArrayList<ContentLabelName> list = new ArrayList<ContentLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContentLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContentLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContentLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CONTENT_LABEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContentLabelName contentLabelName = this;
            synchronized (contentLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.contentLabel != null) {
                        fieldMapBuilder.put((Object)"content_label", (Object)this.contentLabel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CONTENT_LABEL.instantiate(new String[]{"network_code", this.networkCode, "content_label", this.contentLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ContentLabelName that = (ContentLabelName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.contentLabel, that.contentLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.contentLabel);
    }

    public static class Builder {
        private String networkCode;
        private String contentLabel;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getContentLabel() {
            return this.contentLabel;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setContentLabel(String contentLabel) {
            this.contentLabel = contentLabel;
            return this;
        }

        private Builder(ContentLabelName contentLabelName) {
            this.networkCode = contentLabelName.networkCode;
            this.contentLabel = contentLabelName.contentLabel;
        }

        public ContentLabelName build() {
            return new ContentLabelName(this);
        }
    }
}

