/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContentBundleName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CONTENT_BUNDLE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/contentBundles/{content_bundle}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String contentBundle;

    @Deprecated
    protected ContentBundleName() {
        this.networkCode = null;
        this.contentBundle = null;
    }

    private ContentBundleName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.contentBundle = (String)Preconditions.checkNotNull((Object)builder.getContentBundle());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getContentBundle() {
        return this.contentBundle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContentBundleName of(String networkCode, String contentBundle) {
        return ContentBundleName.newBuilder().setNetworkCode(networkCode).setContentBundle(contentBundle).build();
    }

    public static String format(String networkCode, String contentBundle) {
        return ContentBundleName.newBuilder().setNetworkCode(networkCode).setContentBundle(contentBundle).build().toString();
    }

    public static ContentBundleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CONTENT_BUNDLE.validatedMatch(formattedString, "ContentBundleName.parse: formattedString not in valid format");
        return ContentBundleName.of((String)matchMap.get("network_code"), (String)matchMap.get("content_bundle"));
    }

    public static List<ContentBundleName> parseList(List<String> formattedStrings) {
        ArrayList<ContentBundleName> list = new ArrayList<ContentBundleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContentBundleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContentBundleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContentBundleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CONTENT_BUNDLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContentBundleName contentBundleName = this;
            synchronized (contentBundleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.contentBundle != null) {
                        fieldMapBuilder.put((Object)"content_bundle", (Object)this.contentBundle);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CONTENT_BUNDLE.instantiate(new String[]{"network_code", this.networkCode, "content_bundle", this.contentBundle});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ContentBundleName that = (ContentBundleName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.contentBundle, that.contentBundle);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.contentBundle);
    }

    public static class Builder {
        private String networkCode;
        private String contentBundle;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getContentBundle() {
            return this.contentBundle;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setContentBundle(String contentBundle) {
            this.contentBundle = contentBundle;
            return this;
        }

        private Builder(ContentBundleName contentBundleName) {
            this.networkCode = contentBundleName.networkCode;
            this.contentBundle = contentBundleName.contentBundle;
        }

        public ContentBundleName build() {
            return new ContentBundleName(this);
        }
    }
}

