/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CmsMetadataValueName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CMS_METADATA_VALUE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/cmsMetadataValues/{cms_metadata_value}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String cmsMetadataValue;

    @Deprecated
    protected CmsMetadataValueName() {
        this.networkCode = null;
        this.cmsMetadataValue = null;
    }

    private CmsMetadataValueName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.cmsMetadataValue = (String)Preconditions.checkNotNull((Object)builder.getCmsMetadataValue());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getCmsMetadataValue() {
        return this.cmsMetadataValue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CmsMetadataValueName of(String networkCode, String cmsMetadataValue) {
        return CmsMetadataValueName.newBuilder().setNetworkCode(networkCode).setCmsMetadataValue(cmsMetadataValue).build();
    }

    public static String format(String networkCode, String cmsMetadataValue) {
        return CmsMetadataValueName.newBuilder().setNetworkCode(networkCode).setCmsMetadataValue(cmsMetadataValue).build().toString();
    }

    public static CmsMetadataValueName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CMS_METADATA_VALUE.validatedMatch(formattedString, "CmsMetadataValueName.parse: formattedString not in valid format");
        return CmsMetadataValueName.of((String)matchMap.get("network_code"), (String)matchMap.get("cms_metadata_value"));
    }

    public static List<CmsMetadataValueName> parseList(List<String> formattedStrings) {
        ArrayList<CmsMetadataValueName> list = new ArrayList<CmsMetadataValueName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CmsMetadataValueName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CmsMetadataValueName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CmsMetadataValueName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CMS_METADATA_VALUE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CmsMetadataValueName cmsMetadataValueName = this;
            synchronized (cmsMetadataValueName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.cmsMetadataValue != null) {
                        fieldMapBuilder.put((Object)"cms_metadata_value", (Object)this.cmsMetadataValue);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CMS_METADATA_VALUE.instantiate(new String[]{"network_code", this.networkCode, "cms_metadata_value", this.cmsMetadataValue});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CmsMetadataValueName that = (CmsMetadataValueName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.cmsMetadataValue, that.cmsMetadataValue);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cmsMetadataValue);
    }

    public static class Builder {
        private String networkCode;
        private String cmsMetadataValue;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getCmsMetadataValue() {
            return this.cmsMetadataValue;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setCmsMetadataValue(String cmsMetadataValue) {
            this.cmsMetadataValue = cmsMetadataValue;
            return this;
        }

        private Builder(CmsMetadataValueName cmsMetadataValueName) {
            this.networkCode = cmsMetadataValueName.networkCode;
            this.cmsMetadataValue = cmsMetadataValueName.cmsMetadataValue;
        }

        public CmsMetadataValueName build() {
            return new CmsMetadataValueName(this);
        }
    }
}

