/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CmsMetadataKeyName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CMS_METADATA_KEY = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/cmsMetadataKeys/{cms_metadata_key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String cmsMetadataKey;

    @Deprecated
    protected CmsMetadataKeyName() {
        this.networkCode = null;
        this.cmsMetadataKey = null;
    }

    private CmsMetadataKeyName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.cmsMetadataKey = (String)Preconditions.checkNotNull((Object)builder.getCmsMetadataKey());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getCmsMetadataKey() {
        return this.cmsMetadataKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CmsMetadataKeyName of(String networkCode, String cmsMetadataKey) {
        return CmsMetadataKeyName.newBuilder().setNetworkCode(networkCode).setCmsMetadataKey(cmsMetadataKey).build();
    }

    public static String format(String networkCode, String cmsMetadataKey) {
        return CmsMetadataKeyName.newBuilder().setNetworkCode(networkCode).setCmsMetadataKey(cmsMetadataKey).build().toString();
    }

    public static CmsMetadataKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CMS_METADATA_KEY.validatedMatch(formattedString, "CmsMetadataKeyName.parse: formattedString not in valid format");
        return CmsMetadataKeyName.of((String)matchMap.get("network_code"), (String)matchMap.get("cms_metadata_key"));
    }

    public static List<CmsMetadataKeyName> parseList(List<String> formattedStrings) {
        ArrayList<CmsMetadataKeyName> list = new ArrayList<CmsMetadataKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CmsMetadataKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CmsMetadataKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CmsMetadataKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CMS_METADATA_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CmsMetadataKeyName cmsMetadataKeyName = this;
            synchronized (cmsMetadataKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.cmsMetadataKey != null) {
                        fieldMapBuilder.put((Object)"cms_metadata_key", (Object)this.cmsMetadataKey);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CMS_METADATA_KEY.instantiate(new String[]{"network_code", this.networkCode, "cms_metadata_key", this.cmsMetadataKey});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CmsMetadataKeyName that = (CmsMetadataKeyName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.cmsMetadataKey, that.cmsMetadataKey);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cmsMetadataKey);
    }

    public static class Builder {
        private String networkCode;
        private String cmsMetadataKey;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getCmsMetadataKey() {
            return this.cmsMetadataKey;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setCmsMetadataKey(String cmsMetadataKey) {
            this.cmsMetadataKey = cmsMetadataKey;
            return this;
        }

        private Builder(CmsMetadataKeyName cmsMetadataKeyName) {
            this.networkCode = cmsMetadataKeyName.networkCode;
            this.cmsMetadataKey = cmsMetadataKeyName.cmsMetadataKey;
        }

        public CmsMetadataKeyName build() {
            return new CmsMetadataKeyName(this);
        }
    }
}

