/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BrowserName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_BROWSER = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/browsers/{browser}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String browser;

    @Deprecated
    protected BrowserName() {
        this.networkCode = null;
        this.browser = null;
    }

    private BrowserName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.browser = (String)Preconditions.checkNotNull((Object)builder.getBrowser());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getBrowser() {
        return this.browser;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BrowserName of(String networkCode, String browser) {
        return BrowserName.newBuilder().setNetworkCode(networkCode).setBrowser(browser).build();
    }

    public static String format(String networkCode, String browser) {
        return BrowserName.newBuilder().setNetworkCode(networkCode).setBrowser(browser).build().toString();
    }

    public static BrowserName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_BROWSER.validatedMatch(formattedString, "BrowserName.parse: formattedString not in valid format");
        return BrowserName.of((String)matchMap.get("network_code"), (String)matchMap.get("browser"));
    }

    public static List<BrowserName> parseList(List<String> formattedStrings) {
        ArrayList<BrowserName> list = new ArrayList<BrowserName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BrowserName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BrowserName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BrowserName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_BROWSER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BrowserName browserName = this;
            synchronized (browserName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.browser != null) {
                        fieldMapBuilder.put((Object)"browser", (Object)this.browser);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_BROWSER.instantiate(new String[]{"network_code", this.networkCode, "browser", this.browser});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BrowserName that = (BrowserName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.browser, that.browser);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.browser);
    }

    public static class Builder {
        private String networkCode;
        private String browser;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getBrowser() {
            return this.browser;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setBrowser(String browser) {
            this.browser = browser;
            return this;
        }

        private Builder(BrowserName browserName) {
            this.networkCode = browserName.networkCode;
            this.browser = browserName.browser;
        }

        public BrowserName build() {
            return new BrowserName(this);
        }
    }
}

