/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BrowserLanguageName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_BROWSER_LANGUAGE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/browserLanguages/{browser_language}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String browserLanguage;

    @Deprecated
    protected BrowserLanguageName() {
        this.networkCode = null;
        this.browserLanguage = null;
    }

    private BrowserLanguageName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.browserLanguage = (String)Preconditions.checkNotNull((Object)builder.getBrowserLanguage());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getBrowserLanguage() {
        return this.browserLanguage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BrowserLanguageName of(String networkCode, String browserLanguage) {
        return BrowserLanguageName.newBuilder().setNetworkCode(networkCode).setBrowserLanguage(browserLanguage).build();
    }

    public static String format(String networkCode, String browserLanguage) {
        return BrowserLanguageName.newBuilder().setNetworkCode(networkCode).setBrowserLanguage(browserLanguage).build().toString();
    }

    public static BrowserLanguageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_BROWSER_LANGUAGE.validatedMatch(formattedString, "BrowserLanguageName.parse: formattedString not in valid format");
        return BrowserLanguageName.of((String)matchMap.get("network_code"), (String)matchMap.get("browser_language"));
    }

    public static List<BrowserLanguageName> parseList(List<String> formattedStrings) {
        ArrayList<BrowserLanguageName> list = new ArrayList<BrowserLanguageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BrowserLanguageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BrowserLanguageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BrowserLanguageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_BROWSER_LANGUAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BrowserLanguageName browserLanguageName = this;
            synchronized (browserLanguageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.browserLanguage != null) {
                        fieldMapBuilder.put((Object)"browser_language", (Object)this.browserLanguage);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_BROWSER_LANGUAGE.instantiate(new String[]{"network_code", this.networkCode, "browser_language", this.browserLanguage});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BrowserLanguageName that = (BrowserLanguageName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.browserLanguage, that.browserLanguage);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.browserLanguage);
    }

    public static class Builder {
        private String networkCode;
        private String browserLanguage;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getBrowserLanguage() {
            return this.browserLanguage;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setBrowserLanguage(String browserLanguage) {
            this.browserLanguage = browserLanguage;
            return this;
        }

        private Builder(BrowserLanguageName browserLanguageName) {
            this.networkCode = browserLanguageName.networkCode;
            this.browserLanguage = browserLanguageName.browserLanguage;
        }

        public BrowserLanguageName build() {
            return new BrowserLanguageName(this);
        }
    }
}

