/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AudienceSegmentName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_AUDIENCE_SEGMENT = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/audienceSegments/{audience_segment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String audienceSegment;

    @Deprecated
    protected AudienceSegmentName() {
        this.networkCode = null;
        this.audienceSegment = null;
    }

    private AudienceSegmentName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.audienceSegment = (String)Preconditions.checkNotNull((Object)builder.getAudienceSegment());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getAudienceSegment() {
        return this.audienceSegment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AudienceSegmentName of(String networkCode, String audienceSegment) {
        return AudienceSegmentName.newBuilder().setNetworkCode(networkCode).setAudienceSegment(audienceSegment).build();
    }

    public static String format(String networkCode, String audienceSegment) {
        return AudienceSegmentName.newBuilder().setNetworkCode(networkCode).setAudienceSegment(audienceSegment).build().toString();
    }

    public static AudienceSegmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_AUDIENCE_SEGMENT.validatedMatch(formattedString, "AudienceSegmentName.parse: formattedString not in valid format");
        return AudienceSegmentName.of((String)matchMap.get("network_code"), (String)matchMap.get("audience_segment"));
    }

    public static List<AudienceSegmentName> parseList(List<String> formattedStrings) {
        ArrayList<AudienceSegmentName> list = new ArrayList<AudienceSegmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AudienceSegmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AudienceSegmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AudienceSegmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_AUDIENCE_SEGMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AudienceSegmentName audienceSegmentName = this;
            synchronized (audienceSegmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.audienceSegment != null) {
                        fieldMapBuilder.put((Object)"audience_segment", (Object)this.audienceSegment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_AUDIENCE_SEGMENT.instantiate(new String[]{"network_code", this.networkCode, "audience_segment", this.audienceSegment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AudienceSegmentName that = (AudienceSegmentName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.audienceSegment, that.audienceSegment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.audienceSegment);
    }

    public static class Builder {
        private String networkCode;
        private String audienceSegment;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getAudienceSegment() {
            return this.audienceSegment;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setAudienceSegment(String audienceSegment) {
            this.audienceSegment = audienceSegment;
            return this;
        }

        private Builder(AudienceSegmentName audienceSegmentName) {
            this.networkCode = audienceSegmentName.networkCode;
            this.audienceSegment = audienceSegmentName.audienceSegment;
        }

        public AudienceSegmentName build() {
            return new AudienceSegmentName(this);
        }
    }
}

