/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApplicationName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_APPLICATION = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/applications/{application}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String application;

    @Deprecated
    protected ApplicationName() {
        this.networkCode = null;
        this.application = null;
    }

    private ApplicationName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.application = (String)Preconditions.checkNotNull((Object)builder.getApplication());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getApplication() {
        return this.application;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ApplicationName of(String networkCode, String application) {
        return ApplicationName.newBuilder().setNetworkCode(networkCode).setApplication(application).build();
    }

    public static String format(String networkCode, String application) {
        return ApplicationName.newBuilder().setNetworkCode(networkCode).setApplication(application).build().toString();
    }

    public static ApplicationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_APPLICATION.validatedMatch(formattedString, "ApplicationName.parse: formattedString not in valid format");
        return ApplicationName.of((String)matchMap.get("network_code"), (String)matchMap.get("application"));
    }

    public static List<ApplicationName> parseList(List<String> formattedStrings) {
        ArrayList<ApplicationName> list = new ArrayList<ApplicationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ApplicationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ApplicationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ApplicationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_APPLICATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ApplicationName applicationName = this;
            synchronized (applicationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.application != null) {
                        fieldMapBuilder.put((Object)"application", (Object)this.application);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_APPLICATION.instantiate(new String[]{"network_code", this.networkCode, "application", this.application});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ApplicationName that = (ApplicationName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.application, that.application);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.application);
    }

    public static class Builder {
        private String networkCode;
        private String application;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getApplication() {
            return this.application;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setApplication(String application) {
            this.application = application;
            return this;
        }

        private Builder(ApplicationName applicationName) {
            this.networkCode = applicationName.networkCode;
            this.application = applicationName.application;
        }

        public ApplicationName build() {
            return new ApplicationName(this);
        }
    }
}

