/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdUnitName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_AD_UNIT = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/adUnits/{ad_unit}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String adUnit;

    @Deprecated
    protected AdUnitName() {
        this.networkCode = null;
        this.adUnit = null;
    }

    private AdUnitName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.adUnit = (String)Preconditions.checkNotNull((Object)builder.getAdUnit());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getAdUnit() {
        return this.adUnit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdUnitName of(String networkCode, String adUnit) {
        return AdUnitName.newBuilder().setNetworkCode(networkCode).setAdUnit(adUnit).build();
    }

    public static String format(String networkCode, String adUnit) {
        return AdUnitName.newBuilder().setNetworkCode(networkCode).setAdUnit(adUnit).build().toString();
    }

    public static AdUnitName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_AD_UNIT.validatedMatch(formattedString, "AdUnitName.parse: formattedString not in valid format");
        return AdUnitName.of((String)matchMap.get("network_code"), (String)matchMap.get("ad_unit"));
    }

    public static List<AdUnitName> parseList(List<String> formattedStrings) {
        ArrayList<AdUnitName> list = new ArrayList<AdUnitName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdUnitName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdUnitName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdUnitName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_AD_UNIT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdUnitName adUnitName = this;
            synchronized (adUnitName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.adUnit != null) {
                        fieldMapBuilder.put((Object)"ad_unit", (Object)this.adUnit);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_AD_UNIT.instantiate(new String[]{"network_code", this.networkCode, "ad_unit", this.adUnit});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdUnitName that = (AdUnitName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.adUnit, that.adUnit);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.adUnit);
    }

    public static class Builder {
        private String networkCode;
        private String adUnit;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getAdUnit() {
            return this.adUnit;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setAdUnit(String adUnit) {
            this.adUnit = adUnit;
            return this;
        }

        private Builder(AdUnitName adUnitName) {
            this.networkCode = adUnitName.networkCode;
            this.adUnit = adUnitName.adUnit;
        }

        public AdUnitName build() {
            return new AdUnitName(this);
        }
    }
}

