/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProgrammaticBuyerName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_PROGRAMMATIC_BUYER = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/programmaticBuyers/{programmatic_buyer}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String programmaticBuyer;

    @Deprecated
    protected ProgrammaticBuyerName() {
        this.networkCode = null;
        this.programmaticBuyer = null;
    }

    private ProgrammaticBuyerName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.programmaticBuyer = (String)Preconditions.checkNotNull((Object)builder.getProgrammaticBuyer());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getProgrammaticBuyer() {
        return this.programmaticBuyer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProgrammaticBuyerName of(String networkCode, String programmaticBuyer) {
        return ProgrammaticBuyerName.newBuilder().setNetworkCode(networkCode).setProgrammaticBuyer(programmaticBuyer).build();
    }

    public static String format(String networkCode, String programmaticBuyer) {
        return ProgrammaticBuyerName.newBuilder().setNetworkCode(networkCode).setProgrammaticBuyer(programmaticBuyer).build().toString();
    }

    public static ProgrammaticBuyerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_PROGRAMMATIC_BUYER.validatedMatch(formattedString, "ProgrammaticBuyerName.parse: formattedString not in valid format");
        return ProgrammaticBuyerName.of((String)matchMap.get("network_code"), (String)matchMap.get("programmatic_buyer"));
    }

    public static List<ProgrammaticBuyerName> parseList(List<String> formattedStrings) {
        ArrayList<ProgrammaticBuyerName> list = new ArrayList<ProgrammaticBuyerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProgrammaticBuyerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProgrammaticBuyerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProgrammaticBuyerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_PROGRAMMATIC_BUYER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProgrammaticBuyerName programmaticBuyerName = this;
            synchronized (programmaticBuyerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.programmaticBuyer != null) {
                        fieldMapBuilder.put((Object)"programmatic_buyer", (Object)this.programmaticBuyer);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_PROGRAMMATIC_BUYER.instantiate(new String[]{"network_code", this.networkCode, "programmatic_buyer", this.programmaticBuyer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProgrammaticBuyerName that = (ProgrammaticBuyerName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.programmaticBuyer, that.programmaticBuyer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.programmaticBuyer);
    }

    public static class Builder {
        private String networkCode;
        private String programmaticBuyer;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getProgrammaticBuyer() {
            return this.programmaticBuyer;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setProgrammaticBuyer(String programmaticBuyer) {
            this.programmaticBuyer = programmaticBuyer;
            return this;
        }

        private Builder(ProgrammaticBuyerName programmaticBuyerName) {
            this.networkCode = programmaticBuyerName.networkCode;
            this.programmaticBuyer = programmaticBuyerName.programmaticBuyer;
        }

        public ProgrammaticBuyerName build() {
            return new ProgrammaticBuyerName(this);
        }
    }
}

