/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OperatingSystemName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_OPERATING_SYSTEM = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/operatingSystems/{operating_system}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String operatingSystem;

    @Deprecated
    protected OperatingSystemName() {
        this.networkCode = null;
        this.operatingSystem = null;
    }

    private OperatingSystemName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.operatingSystem = (String)Preconditions.checkNotNull((Object)builder.getOperatingSystem());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OperatingSystemName of(String networkCode, String operatingSystem) {
        return OperatingSystemName.newBuilder().setNetworkCode(networkCode).setOperatingSystem(operatingSystem).build();
    }

    public static String format(String networkCode, String operatingSystem) {
        return OperatingSystemName.newBuilder().setNetworkCode(networkCode).setOperatingSystem(operatingSystem).build().toString();
    }

    public static OperatingSystemName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_OPERATING_SYSTEM.validatedMatch(formattedString, "OperatingSystemName.parse: formattedString not in valid format");
        return OperatingSystemName.of((String)matchMap.get("network_code"), (String)matchMap.get("operating_system"));
    }

    public static List<OperatingSystemName> parseList(List<String> formattedStrings) {
        ArrayList<OperatingSystemName> list = new ArrayList<OperatingSystemName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OperatingSystemName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OperatingSystemName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OperatingSystemName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_OPERATING_SYSTEM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OperatingSystemName operatingSystemName = this;
            synchronized (operatingSystemName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.operatingSystem != null) {
                        fieldMapBuilder.put((Object)"operating_system", (Object)this.operatingSystem);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_OPERATING_SYSTEM.instantiate(new String[]{"network_code", this.networkCode, "operating_system", this.operatingSystem});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OperatingSystemName that = (OperatingSystemName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.operatingSystem, that.operatingSystem);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.operatingSystem);
    }

    public static class Builder {
        private String networkCode;
        private String operatingSystem;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getOperatingSystem() {
            return this.operatingSystem;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        private Builder(OperatingSystemName operatingSystemName) {
            this.networkCode = operatingSystemName.networkCode;
            this.operatingSystem = operatingSystemName.operatingSystem;
        }

        public OperatingSystemName build() {
            return new OperatingSystemName(this);
        }
    }
}

