/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GeoTargetName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_GEO_TARGET = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/geoTargets/{geo_target}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String geoTarget;

    @Deprecated
    protected GeoTargetName() {
        this.networkCode = null;
        this.geoTarget = null;
    }

    private GeoTargetName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.geoTarget = (String)Preconditions.checkNotNull((Object)builder.getGeoTarget());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getGeoTarget() {
        return this.geoTarget;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GeoTargetName of(String networkCode, String geoTarget) {
        return GeoTargetName.newBuilder().setNetworkCode(networkCode).setGeoTarget(geoTarget).build();
    }

    public static String format(String networkCode, String geoTarget) {
        return GeoTargetName.newBuilder().setNetworkCode(networkCode).setGeoTarget(geoTarget).build().toString();
    }

    public static GeoTargetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_GEO_TARGET.validatedMatch(formattedString, "GeoTargetName.parse: formattedString not in valid format");
        return GeoTargetName.of((String)matchMap.get("network_code"), (String)matchMap.get("geo_target"));
    }

    public static List<GeoTargetName> parseList(List<String> formattedStrings) {
        ArrayList<GeoTargetName> list = new ArrayList<GeoTargetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GeoTargetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GeoTargetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GeoTargetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_GEO_TARGET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GeoTargetName geoTargetName = this;
            synchronized (geoTargetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.geoTarget != null) {
                        fieldMapBuilder.put((Object)"geo_target", (Object)this.geoTarget);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_GEO_TARGET.instantiate(new String[]{"network_code", this.networkCode, "geo_target", this.geoTarget});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GeoTargetName that = (GeoTargetName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.geoTarget, that.geoTarget);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.geoTarget);
    }

    public static class Builder {
        private String networkCode;
        private String geoTarget;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getGeoTarget() {
            return this.geoTarget;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setGeoTarget(String geoTarget) {
            this.geoTarget = geoTarget;
            return this;
        }

        private Builder(GeoTargetName geoTargetName) {
            this.networkCode = geoTargetName.networkCode;
            this.geoTarget = geoTargetName.geoTarget;
        }

        public GeoTargetName build() {
            return new GeoTargetName(this);
        }
    }
}

