/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrivateAuctionName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_PRIVATE_AUCTION = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/privateAuctions/{private_auction}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String privateAuction;

    @Deprecated
    protected PrivateAuctionName() {
        this.networkCode = null;
        this.privateAuction = null;
    }

    private PrivateAuctionName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.privateAuction = (String)Preconditions.checkNotNull((Object)builder.getPrivateAuction());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getPrivateAuction() {
        return this.privateAuction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PrivateAuctionName of(String networkCode, String privateAuction) {
        return PrivateAuctionName.newBuilder().setNetworkCode(networkCode).setPrivateAuction(privateAuction).build();
    }

    public static String format(String networkCode, String privateAuction) {
        return PrivateAuctionName.newBuilder().setNetworkCode(networkCode).setPrivateAuction(privateAuction).build().toString();
    }

    public static PrivateAuctionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_PRIVATE_AUCTION.validatedMatch(formattedString, "PrivateAuctionName.parse: formattedString not in valid format");
        return PrivateAuctionName.of((String)matchMap.get("network_code"), (String)matchMap.get("private_auction"));
    }

    public static List<PrivateAuctionName> parseList(List<String> formattedStrings) {
        ArrayList<PrivateAuctionName> list = new ArrayList<PrivateAuctionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PrivateAuctionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PrivateAuctionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PrivateAuctionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_PRIVATE_AUCTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PrivateAuctionName privateAuctionName = this;
            synchronized (privateAuctionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.privateAuction != null) {
                        fieldMapBuilder.put((Object)"private_auction", (Object)this.privateAuction);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_PRIVATE_AUCTION.instantiate(new String[]{"network_code", this.networkCode, "private_auction", this.privateAuction});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PrivateAuctionName that = (PrivateAuctionName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.privateAuction, that.privateAuction);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.privateAuction);
    }

    public static class Builder {
        private String networkCode;
        private String privateAuction;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getPrivateAuction() {
            return this.privateAuction;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setPrivateAuction(String privateAuction) {
            this.privateAuction = privateAuction;
            return this;
        }

        private Builder(PrivateAuctionName privateAuctionName) {
            this.networkCode = privateAuctionName.networkCode;
            this.privateAuction = privateAuctionName.privateAuction;
        }

        public PrivateAuctionName build() {
            return new PrivateAuctionName(this);
        }
    }
}

