/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrderName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_ORDER = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/orders/{order}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String order;

    @Deprecated
    protected OrderName() {
        this.networkCode = null;
        this.order = null;
    }

    private OrderName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.order = (String)Preconditions.checkNotNull((Object)builder.getOrder());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getOrder() {
        return this.order;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrderName of(String networkCode, String order) {
        return OrderName.newBuilder().setNetworkCode(networkCode).setOrder(order).build();
    }

    public static String format(String networkCode, String order) {
        return OrderName.newBuilder().setNetworkCode(networkCode).setOrder(order).build().toString();
    }

    public static OrderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_ORDER.validatedMatch(formattedString, "OrderName.parse: formattedString not in valid format");
        return OrderName.of((String)matchMap.get("network_code"), (String)matchMap.get("order"));
    }

    public static List<OrderName> parseList(List<String> formattedStrings) {
        ArrayList<OrderName> list = new ArrayList<OrderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_ORDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrderName orderName = this;
            synchronized (orderName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.order != null) {
                        fieldMapBuilder.put((Object)"order", (Object)this.order);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_ORDER.instantiate(new String[]{"network_code", this.networkCode, "order", this.order});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrderName that = (OrderName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.order, that.order);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.order);
    }

    public static class Builder {
        private String networkCode;
        private String order;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getOrder() {
            return this.order;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setOrder(String order) {
            this.order = order;
            return this;
        }

        private Builder(OrderName orderName) {
            this.networkCode = orderName.networkCode;
            this.order = orderName.order;
        }

        public OrderName build() {
            return new OrderName(this);
        }
    }
}

