/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdBreakName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_ASSET_KEY_AD_BREAK = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}/adBreaks/{ad_break}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String assetKey;
    private final String adBreak;

    @Deprecated
    protected AdBreakName() {
        this.networkCode = null;
        this.assetKey = null;
        this.adBreak = null;
    }

    private AdBreakName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.assetKey = (String)Preconditions.checkNotNull((Object)builder.getAssetKey());
        this.adBreak = (String)Preconditions.checkNotNull((Object)builder.getAdBreak());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getAssetKey() {
        return this.assetKey;
    }

    public String getAdBreak() {
        return this.adBreak;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdBreakName of(String networkCode, String assetKey, String adBreak) {
        return AdBreakName.newBuilder().setNetworkCode(networkCode).setAssetKey(assetKey).setAdBreak(adBreak).build();
    }

    public static String format(String networkCode, String assetKey, String adBreak) {
        return AdBreakName.newBuilder().setNetworkCode(networkCode).setAssetKey(assetKey).setAdBreak(adBreak).build().toString();
    }

    public static AdBreakName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_ASSET_KEY_AD_BREAK.validatedMatch(formattedString, "AdBreakName.parse: formattedString not in valid format");
        return AdBreakName.of((String)matchMap.get("network_code"), (String)matchMap.get("asset_key"), (String)matchMap.get("ad_break"));
    }

    public static List<AdBreakName> parseList(List<String> formattedStrings) {
        ArrayList<AdBreakName> list = new ArrayList<AdBreakName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdBreakName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdBreakName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdBreakName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_ASSET_KEY_AD_BREAK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdBreakName adBreakName = this;
            synchronized (adBreakName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.assetKey != null) {
                        fieldMapBuilder.put((Object)"asset_key", (Object)this.assetKey);
                    }
                    if (this.adBreak != null) {
                        fieldMapBuilder.put((Object)"ad_break", (Object)this.adBreak);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_ASSET_KEY_AD_BREAK.instantiate(new String[]{"network_code", this.networkCode, "asset_key", this.assetKey, "ad_break", this.adBreak});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdBreakName that = (AdBreakName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.assetKey, that.assetKey) && Objects.equals(this.adBreak, that.adBreak);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetKey);
        h *= 1000003;
        return h ^= Objects.hashCode(this.adBreak);
    }

    public static class Builder {
        private String networkCode;
        private String assetKey;
        private String adBreak;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getAssetKey() {
            return this.assetKey;
        }

        public String getAdBreak() {
            return this.adBreak;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setAssetKey(String assetKey) {
            this.assetKey = assetKey;
            return this;
        }

        public Builder setAdBreak(String adBreak) {
            this.adBreak = adBreak;
            return this;
        }

        private Builder(AdBreakName adBreakName) {
            this.networkCode = adBreakName.networkCode;
            this.assetKey = adBreakName.assetKey;
            this.adBreak = adBreakName.adBreak;
        }

        public AdBreakName build() {
            return new AdBreakName(this);
        }
    }
}

