/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RoleName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_ROLE = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/roles/{role}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String role;

    @Deprecated
    protected RoleName() {
        this.networkCode = null;
        this.role = null;
    }

    private RoleName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.role = (String)Preconditions.checkNotNull((Object)builder.getRole());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getRole() {
        return this.role;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RoleName of(String networkCode, String role) {
        return RoleName.newBuilder().setNetworkCode(networkCode).setRole(role).build();
    }

    public static String format(String networkCode, String role) {
        return RoleName.newBuilder().setNetworkCode(networkCode).setRole(role).build().toString();
    }

    public static RoleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_ROLE.validatedMatch(formattedString, "RoleName.parse: formattedString not in valid format");
        return RoleName.of((String)matchMap.get("network_code"), (String)matchMap.get("role"));
    }

    public static List<RoleName> parseList(List<String> formattedStrings) {
        ArrayList<RoleName> list = new ArrayList<RoleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RoleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RoleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RoleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_ROLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RoleName roleName = this;
            synchronized (roleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.role != null) {
                        fieldMapBuilder.put((Object)"role", (Object)this.role);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_ROLE.instantiate(new String[]{"network_code", this.networkCode, "role", this.role});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RoleName that = (RoleName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.role, that.role);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.role);
    }

    public static class Builder {
        private String networkCode;
        private String role;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getRole() {
            return this.role;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setRole(String role) {
            this.role = role;
            return this;
        }

        private Builder(RoleName roleName) {
            this.networkCode = roleName.networkCode;
            this.role = roleName.role;
        }

        public RoleName build() {
            return new RoleName(this);
        }
    }
}

