/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrivateAuctionDealName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_PRIVATE_AUCTION_DEAL = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/privateAuctionDeals/{private_auction_deal}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String privateAuctionDeal;

    @Deprecated
    protected PrivateAuctionDealName() {
        this.networkCode = null;
        this.privateAuctionDeal = null;
    }

    private PrivateAuctionDealName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.privateAuctionDeal = (String)Preconditions.checkNotNull((Object)builder.getPrivateAuctionDeal());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getPrivateAuctionDeal() {
        return this.privateAuctionDeal;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PrivateAuctionDealName of(String networkCode, String privateAuctionDeal) {
        return PrivateAuctionDealName.newBuilder().setNetworkCode(networkCode).setPrivateAuctionDeal(privateAuctionDeal).build();
    }

    public static String format(String networkCode, String privateAuctionDeal) {
        return PrivateAuctionDealName.newBuilder().setNetworkCode(networkCode).setPrivateAuctionDeal(privateAuctionDeal).build().toString();
    }

    public static PrivateAuctionDealName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_PRIVATE_AUCTION_DEAL.validatedMatch(formattedString, "PrivateAuctionDealName.parse: formattedString not in valid format");
        return PrivateAuctionDealName.of((String)matchMap.get("network_code"), (String)matchMap.get("private_auction_deal"));
    }

    public static List<PrivateAuctionDealName> parseList(List<String> formattedStrings) {
        ArrayList<PrivateAuctionDealName> list = new ArrayList<PrivateAuctionDealName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PrivateAuctionDealName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PrivateAuctionDealName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PrivateAuctionDealName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_PRIVATE_AUCTION_DEAL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PrivateAuctionDealName privateAuctionDealName = this;
            synchronized (privateAuctionDealName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.privateAuctionDeal != null) {
                        fieldMapBuilder.put((Object)"private_auction_deal", (Object)this.privateAuctionDeal);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_PRIVATE_AUCTION_DEAL.instantiate(new String[]{"network_code", this.networkCode, "private_auction_deal", this.privateAuctionDeal});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PrivateAuctionDealName that = (PrivateAuctionDealName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.privateAuctionDeal, that.privateAuctionDeal);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.privateAuctionDeal);
    }

    public static class Builder {
        private String networkCode;
        private String privateAuctionDeal;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getPrivateAuctionDeal() {
            return this.privateAuctionDeal;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setPrivateAuctionDeal(String privateAuctionDeal) {
            this.privateAuctionDeal = privateAuctionDeal;
            return this;
        }

        private Builder(PrivateAuctionDealName privateAuctionDealName) {
            this.networkCode = privateAuctionDealName.networkCode;
            this.privateAuctionDeal = privateAuctionDealName.privateAuctionDeal;
        }

        public PrivateAuctionDealName build() {
            return new PrivateAuctionDealName(this);
        }
    }
}

