/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CompanyName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_COMPANY = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/companies/{company}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String company;

    @Deprecated
    protected CompanyName() {
        this.networkCode = null;
        this.company = null;
    }

    private CompanyName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.company = (String)Preconditions.checkNotNull((Object)builder.getCompany());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getCompany() {
        return this.company;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CompanyName of(String networkCode, String company) {
        return CompanyName.newBuilder().setNetworkCode(networkCode).setCompany(company).build();
    }

    public static String format(String networkCode, String company) {
        return CompanyName.newBuilder().setNetworkCode(networkCode).setCompany(company).build().toString();
    }

    public static CompanyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_COMPANY.validatedMatch(formattedString, "CompanyName.parse: formattedString not in valid format");
        return CompanyName.of((String)matchMap.get("network_code"), (String)matchMap.get("company"));
    }

    public static List<CompanyName> parseList(List<String> formattedStrings) {
        ArrayList<CompanyName> list = new ArrayList<CompanyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CompanyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CompanyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CompanyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_COMPANY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CompanyName companyName = this;
            synchronized (companyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.company != null) {
                        fieldMapBuilder.put((Object)"company", (Object)this.company);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_COMPANY.instantiate(new String[]{"network_code", this.networkCode, "company", this.company});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CompanyName that = (CompanyName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.company, that.company);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.company);
    }

    public static class Builder {
        private String networkCode;
        private String company;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getCompany() {
            return this.company;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setCompany(String company) {
            this.company = company;
            return this;
        }

        private Builder(CompanyName companyName) {
            this.networkCode = companyName.networkCode;
            this.company = companyName.company;
        }

        public CompanyName build() {
            return new CompanyName(this);
        }
    }
}

