/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BandwidthGroupName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_BANDWIDTH_GROUP = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/bandwidthGroups/{bandwidth_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String bandwidthGroup;

    @Deprecated
    protected BandwidthGroupName() {
        this.networkCode = null;
        this.bandwidthGroup = null;
    }

    private BandwidthGroupName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.bandwidthGroup = (String)Preconditions.checkNotNull((Object)builder.getBandwidthGroup());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getBandwidthGroup() {
        return this.bandwidthGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BandwidthGroupName of(String networkCode, String bandwidthGroup) {
        return BandwidthGroupName.newBuilder().setNetworkCode(networkCode).setBandwidthGroup(bandwidthGroup).build();
    }

    public static String format(String networkCode, String bandwidthGroup) {
        return BandwidthGroupName.newBuilder().setNetworkCode(networkCode).setBandwidthGroup(bandwidthGroup).build().toString();
    }

    public static BandwidthGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_BANDWIDTH_GROUP.validatedMatch(formattedString, "BandwidthGroupName.parse: formattedString not in valid format");
        return BandwidthGroupName.of((String)matchMap.get("network_code"), (String)matchMap.get("bandwidth_group"));
    }

    public static List<BandwidthGroupName> parseList(List<String> formattedStrings) {
        ArrayList<BandwidthGroupName> list = new ArrayList<BandwidthGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BandwidthGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BandwidthGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BandwidthGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_BANDWIDTH_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BandwidthGroupName bandwidthGroupName = this;
            synchronized (bandwidthGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.bandwidthGroup != null) {
                        fieldMapBuilder.put((Object)"bandwidth_group", (Object)this.bandwidthGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_BANDWIDTH_GROUP.instantiate(new String[]{"network_code", this.networkCode, "bandwidth_group", this.bandwidthGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BandwidthGroupName that = (BandwidthGroupName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.bandwidthGroup, that.bandwidthGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.bandwidthGroup);
    }

    public static class Builder {
        private String networkCode;
        private String bandwidthGroup;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getBandwidthGroup() {
            return this.bandwidthGroup;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setBandwidthGroup(String bandwidthGroup) {
            this.bandwidthGroup = bandwidthGroup;
            return this;
        }

        private Builder(BandwidthGroupName bandwidthGroupName) {
            this.networkCode = bandwidthGroupName.networkCode;
            this.bandwidthGroup = bandwidthGroupName.bandwidthGroup;
        }

        public BandwidthGroupName build() {
            return new BandwidthGroupName(this);
        }
    }
}

