/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomTargetingKeyName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_CUSTOM_TARGETING_KEY = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/customTargetingKeys/{custom_targeting_key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String customTargetingKey;

    @Deprecated
    protected CustomTargetingKeyName() {
        this.networkCode = null;
        this.customTargetingKey = null;
    }

    private CustomTargetingKeyName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.customTargetingKey = (String)Preconditions.checkNotNull((Object)builder.getCustomTargetingKey());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getCustomTargetingKey() {
        return this.customTargetingKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomTargetingKeyName of(String networkCode, String customTargetingKey) {
        return CustomTargetingKeyName.newBuilder().setNetworkCode(networkCode).setCustomTargetingKey(customTargetingKey).build();
    }

    public static String format(String networkCode, String customTargetingKey) {
        return CustomTargetingKeyName.newBuilder().setNetworkCode(networkCode).setCustomTargetingKey(customTargetingKey).build().toString();
    }

    public static CustomTargetingKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_CUSTOM_TARGETING_KEY.validatedMatch(formattedString, "CustomTargetingKeyName.parse: formattedString not in valid format");
        return CustomTargetingKeyName.of((String)matchMap.get("network_code"), (String)matchMap.get("custom_targeting_key"));
    }

    public static List<CustomTargetingKeyName> parseList(List<String> formattedStrings) {
        ArrayList<CustomTargetingKeyName> list = new ArrayList<CustomTargetingKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomTargetingKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomTargetingKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomTargetingKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_CUSTOM_TARGETING_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomTargetingKeyName customTargetingKeyName = this;
            synchronized (customTargetingKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.customTargetingKey != null) {
                        fieldMapBuilder.put((Object)"custom_targeting_key", (Object)this.customTargetingKey);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_CUSTOM_TARGETING_KEY.instantiate(new String[]{"network_code", this.networkCode, "custom_targeting_key", this.customTargetingKey});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomTargetingKeyName that = (CustomTargetingKeyName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.customTargetingKey, that.customTargetingKey);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customTargetingKey);
    }

    public static class Builder {
        private String networkCode;
        private String customTargetingKey;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getCustomTargetingKey() {
            return this.customTargetingKey;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setCustomTargetingKey(String customTargetingKey) {
            this.customTargetingKey = customTargetingKey;
            return this;
        }

        private Builder(CustomTargetingKeyName customTargetingKeyName) {
            this.networkCode = customTargetingKeyName.networkCode;
            this.customTargetingKey = customTargetingKeyName.customTargetingKey;
        }

        public CustomTargetingKeyName build() {
            return new CustomTargetingKeyName(this);
        }
    }
}

