/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaxonomyCategoryName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_TAXONOMY_CATEGORY = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/taxonomyCategories/{taxonomy_category}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String taxonomyCategory;

    @Deprecated
    protected TaxonomyCategoryName() {
        this.networkCode = null;
        this.taxonomyCategory = null;
    }

    private TaxonomyCategoryName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.taxonomyCategory = (String)Preconditions.checkNotNull((Object)builder.getTaxonomyCategory());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getTaxonomyCategory() {
        return this.taxonomyCategory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TaxonomyCategoryName of(String networkCode, String taxonomyCategory) {
        return TaxonomyCategoryName.newBuilder().setNetworkCode(networkCode).setTaxonomyCategory(taxonomyCategory).build();
    }

    public static String format(String networkCode, String taxonomyCategory) {
        return TaxonomyCategoryName.newBuilder().setNetworkCode(networkCode).setTaxonomyCategory(taxonomyCategory).build().toString();
    }

    public static TaxonomyCategoryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_TAXONOMY_CATEGORY.validatedMatch(formattedString, "TaxonomyCategoryName.parse: formattedString not in valid format");
        return TaxonomyCategoryName.of((String)matchMap.get("network_code"), (String)matchMap.get("taxonomy_category"));
    }

    public static List<TaxonomyCategoryName> parseList(List<String> formattedStrings) {
        ArrayList<TaxonomyCategoryName> list = new ArrayList<TaxonomyCategoryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TaxonomyCategoryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TaxonomyCategoryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TaxonomyCategoryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_TAXONOMY_CATEGORY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TaxonomyCategoryName taxonomyCategoryName = this;
            synchronized (taxonomyCategoryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.taxonomyCategory != null) {
                        fieldMapBuilder.put((Object)"taxonomy_category", (Object)this.taxonomyCategory);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_TAXONOMY_CATEGORY.instantiate(new String[]{"network_code", this.networkCode, "taxonomy_category", this.taxonomyCategory});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TaxonomyCategoryName that = (TaxonomyCategoryName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.taxonomyCategory, that.taxonomyCategory);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.taxonomyCategory);
    }

    public static class Builder {
        private String networkCode;
        private String taxonomyCategory;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getTaxonomyCategory() {
            return this.taxonomyCategory;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setTaxonomyCategory(String taxonomyCategory) {
            this.taxonomyCategory = taxonomyCategory;
            return this;
        }

        private Builder(TaxonomyCategoryName taxonomyCategoryName) {
            this.networkCode = taxonomyCategoryName.networkCode;
            this.taxonomyCategory = taxonomyCategoryName.taxonomyCategory;
        }

        public TaxonomyCategoryName build() {
            return new TaxonomyCategoryName(this);
        }
    }
}

