/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntitySignalsMappingName
implements ResourceName {
    private static final PathTemplate NETWORK_CODE_ENTITY_SIGNALS_MAPPING = PathTemplate.createWithoutUrlEncoding((String)"networks/{network_code}/entitySignalsMappings/{entity_signals_mapping}");
    private volatile Map<String, String> fieldValuesMap;
    private final String networkCode;
    private final String entitySignalsMapping;

    @Deprecated
    protected EntitySignalsMappingName() {
        this.networkCode = null;
        this.entitySignalsMapping = null;
    }

    private EntitySignalsMappingName(Builder builder) {
        this.networkCode = (String)Preconditions.checkNotNull((Object)builder.getNetworkCode());
        this.entitySignalsMapping = (String)Preconditions.checkNotNull((Object)builder.getEntitySignalsMapping());
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getEntitySignalsMapping() {
        return this.entitySignalsMapping;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntitySignalsMappingName of(String networkCode, String entitySignalsMapping) {
        return EntitySignalsMappingName.newBuilder().setNetworkCode(networkCode).setEntitySignalsMapping(entitySignalsMapping).build();
    }

    public static String format(String networkCode, String entitySignalsMapping) {
        return EntitySignalsMappingName.newBuilder().setNetworkCode(networkCode).setEntitySignalsMapping(entitySignalsMapping).build().toString();
    }

    public static EntitySignalsMappingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = NETWORK_CODE_ENTITY_SIGNALS_MAPPING.validatedMatch(formattedString, "EntitySignalsMappingName.parse: formattedString not in valid format");
        return EntitySignalsMappingName.of((String)matchMap.get("network_code"), (String)matchMap.get("entity_signals_mapping"));
    }

    public static List<EntitySignalsMappingName> parseList(List<String> formattedStrings) {
        ArrayList<EntitySignalsMappingName> list = new ArrayList<EntitySignalsMappingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntitySignalsMappingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntitySignalsMappingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntitySignalsMappingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return NETWORK_CODE_ENTITY_SIGNALS_MAPPING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntitySignalsMappingName entitySignalsMappingName = this;
            synchronized (entitySignalsMappingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.networkCode != null) {
                        fieldMapBuilder.put((Object)"network_code", (Object)this.networkCode);
                    }
                    if (this.entitySignalsMapping != null) {
                        fieldMapBuilder.put((Object)"entity_signals_mapping", (Object)this.entitySignalsMapping);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return NETWORK_CODE_ENTITY_SIGNALS_MAPPING.instantiate(new String[]{"network_code", this.networkCode, "entity_signals_mapping", this.entitySignalsMapping});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntitySignalsMappingName that = (EntitySignalsMappingName)o;
            return Objects.equals(this.networkCode, that.networkCode) && Objects.equals(this.entitySignalsMapping, that.entitySignalsMapping);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.networkCode);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entitySignalsMapping);
    }

    public static class Builder {
        private String networkCode;
        private String entitySignalsMapping;

        protected Builder() {
        }

        public String getNetworkCode() {
            return this.networkCode;
        }

        public String getEntitySignalsMapping() {
            return this.entitySignalsMapping;
        }

        public Builder setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
            return this;
        }

        public Builder setEntitySignalsMapping(String entitySignalsMapping) {
            this.entitySignalsMapping = entitySignalsMapping;
            return this;
        }

        private Builder(EntitySignalsMappingName entitySignalsMappingName) {
            this.networkCode = entitySignalsMappingName.networkCode;
            this.entitySignalsMapping = entitySignalsMappingName.entitySignalsMapping;
        }

        public EntitySignalsMappingName build() {
            return new EntitySignalsMappingName(this);
        }
    }
}

