/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201806;

import com.google.api.ads.adwords.axis.utils.v201806.ServiceQuery;
import com.google.api.ads.adwords.axis.v201806.cm.Page;
import com.google.api.ads.adwords.axis.v201806.cm.SortOrder;
import com.google.api.ads.adwords.lib.selectorfields.EntityField;
import com.google.api.ads.adwords.lib.utils.QueryBuilder;
import com.google.api.ads.adwords.lib.utils.ServiceQueryInterface;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;

public class ServiceQueryBuilderImpl
extends QueryBuilder<ServiceQueryBuilderImpl, ServiceQueryInterface<Page>>
implements ServiceQueryInterface.BuilderInterface<Page, SortOrder> {
    private final ServiceQuery.Builder builder;
    private NavigableSet<String> fields = ImmutableSortedSet.of();
    private Map<String, String> orderByMultiMap = Maps.newLinkedHashMap();
    private int startIndex;
    private int pageSize;
    private boolean limitCalled = false;

    ServiceQueryBuilderImpl(ServiceQuery.Builder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"The passed builder cannot be null.");
        this.builder = builder;
    }

    ServiceQueryBuilderImpl(ServiceQueryBuilderImpl builderImpl) {
        super((QueryBuilder)builderImpl);
        Preconditions.checkNotNull((Object)((Object)builderImpl), (Object)"The query builder cannot be null.");
        this.builder = builderImpl.builder;
        this.fields = ImmutableSortedSet.copyOf(builderImpl.fields);
        this.orderByMultiMap = Maps.newLinkedHashMap(builderImpl.orderByMultiMap);
        this.startIndex = builderImpl.startIndex;
        this.pageSize = builderImpl.pageSize;
        this.limitCalled = builderImpl.limitCalled;
    }

    public ServiceWhereBuilder where(EntityField field) {
        Preconditions.checkNotNull((Object)field, (Object)"The passed field cannot be null.");
        QueryBuilder.WhereBuilder whereBuilderDelegate = new QueryBuilder.WhereBuilder((QueryBuilder)this, field.name());
        this.whereBuilders.add(whereBuilderDelegate);
        return new ServiceWhereBuilder(whereBuilderDelegate);
    }

    public ServiceWhereBuilder where(String field) {
        QueryBuilder.WhereBuilder whereBuilderDelegate = new QueryBuilder.WhereBuilder((QueryBuilder)this, field);
        this.whereBuilders.add(whereBuilderDelegate);
        return new ServiceWhereBuilder(whereBuilderDelegate);
    }

    public ServiceQuery.Builder fields(EntityField ... fields) {
        Preconditions.checkNotNull((Object)fields, (Object)"Fields to be selected cannot be null.");
        this.fields = ImmutableSortedSet.copyOf((Collection)Lists.transform((List)Lists.newArrayList((Object[])fields), (Function)new Function<EntityField, String>(){

            public String apply(EntityField input) {
                return input.name();
            }
        }));
        return this.builder;
    }

    public ServiceQuery.Builder fields(String ... fields) {
        Preconditions.checkNotNull((Object)fields, (Object)"Fields to be selected cannot be null.");
        this.fields = ImmutableSortedSet.copyOf((Comparable[])fields);
        return this.builder;
    }

    public ServiceQuery.Builder fields(Iterable<String> fields) {
        Preconditions.checkNotNull(fields, (Object)"Fields to be selected cannot be null.");
        this.fields = ImmutableSortedSet.copyOf(fields);
        return this.builder;
    }

    public ServiceQuery.Builder orderBy(EntityField field) {
        this.orderBy(field, SortOrder.ASCENDING);
        return this.builder;
    }

    public ServiceQuery.Builder orderBy(EntityField field, SortOrder order) {
        Preconditions.checkNotNull((Object)field, (Object)"Field must not be null.");
        Preconditions.checkNotNull((Object)order, (Object)"Order must not be null.");
        this.orderByMultiMap.put(field.name(), order.equals(SortOrder.ASCENDING) ? "ASC" : "DESC");
        return this.builder;
    }

    public ServiceQuery.Builder orderBy(String field) {
        this.orderBy(field, SortOrder.ASCENDING);
        return this.builder;
    }

    public ServiceQuery.Builder orderBy(String field, SortOrder order) {
        Preconditions.checkNotNull((Object)field, (Object)"Field must not be null.");
        Preconditions.checkNotNull((Object)order, (Object)"Order must not be null.");
        this.orderByMultiMap.put(field, order.equals(SortOrder.ASCENDING) ? "ASC" : "DESC");
        return this.builder;
    }

    public ServiceQuery.Builder limit(int startIndex, int pageSize) {
        if (pageSize == 0) {
            throw new IllegalArgumentException("Page size must not be zero, as you'll get no results.");
        }
        this.limitCalled = true;
        this.startIndex = startIndex;
        this.pageSize = pageSize;
        return this.builder;
    }

    public ServiceQuery build() {
        this.validate();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        Joiner.on((String)", ").skipNulls().appendTo(stringBuilder, this.fields);
        if (!this.whereBuilders.isEmpty()) {
            stringBuilder.append(String.format(" WHERE %s", Joiner.on((String)" AND ").skipNulls().join((Iterable)this.whereBuilders)));
        }
        if (!this.orderByMultiMap.isEmpty()) {
            ArrayList orderByList = Lists.newArrayList((Iterable)Iterables.transform(this.orderByMultiMap.entrySet(), (Function)new Function<Map.Entry<String, String>, String>(){

                public String apply(Map.Entry<String, String> orderByPair) {
                    return String.format("%s %s", orderByPair.getKey(), orderByPair.getValue());
                }
            }));
            stringBuilder.append(String.format(" ORDER BY %s", Joiner.on((String)", ").skipNulls().join((Iterable)orderByList)));
        }
        return new ServiceQuery(stringBuilder.toString(), this.startIndex, this.pageSize);
    }

    private void validate() {
        if (this.fields.isEmpty()) {
            throw new IllegalStateException("Must use fields() to specify the SELECT clause first.");
        }
        if (!this.limitCalled) {
            throw new IllegalStateException("Must use limit() to specify the LIMIT clause first.");
        }
    }

    class ServiceWhereBuilder
    implements ServiceQueryInterface.BuilderInterface.ServiceWhereBuilderInterface<Page, SortOrder, ServiceQuery.Builder> {
        private final QueryBuilder.WhereBuilder whereBuilderDelegate;

        ServiceWhereBuilder(QueryBuilder.WhereBuilder whereBuilderDelegate) {
            this.whereBuilderDelegate = whereBuilderDelegate;
        }

        public String toString() {
            return this.whereBuilderDelegate.toString();
        }

        public ServiceQuery.Builder equalTo(String propertyValue) {
            this.whereBuilderDelegate.equalTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder equalTo(int propertyValue) {
            this.whereBuilderDelegate.equalTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder equalTo(long propertyValue) {
            this.whereBuilderDelegate.equalTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder equalTo(boolean propertyValue) {
            this.whereBuilderDelegate.equalTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notEqualTo(String propertyValue) {
            this.whereBuilderDelegate.notEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notEqualTo(int propertyValue) {
            this.whereBuilderDelegate.notEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notEqualTo(long propertyValue) {
            this.whereBuilderDelegate.notEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notEqualTo(boolean propertyValue) {
            this.whereBuilderDelegate.notEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder contains(String propertyValue) {
            this.whereBuilderDelegate.contains(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsIgnoreCase(String propertyValue) {
            this.whereBuilderDelegate.containsIgnoreCase(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder doesNotContain(String propertyValue) {
            this.whereBuilderDelegate.doesNotContain(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder doesNotContainIgnoreCase(String propertyValue) {
            this.whereBuilderDelegate.doesNotContainIgnoreCase(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder greaterThan(long propertyValue) {
            this.whereBuilderDelegate.greaterThan(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder greaterThan(int propertyValue) {
            this.whereBuilderDelegate.greaterThan(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder greaterThan(double propertyValue) {
            this.whereBuilderDelegate.greaterThan(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder greaterThanOrEqualTo(long propertyValue) {
            this.whereBuilderDelegate.greaterThanOrEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder greaterThanOrEqualTo(int propertyValue) {
            this.whereBuilderDelegate.greaterThanOrEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder greaterThanOrEqualTo(double propertyValue) {
            this.whereBuilderDelegate.greaterThanOrEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder lessThan(long propertyValue) {
            this.whereBuilderDelegate.lessThan(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder lessThan(int propertyValue) {
            this.whereBuilderDelegate.lessThan(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder lessThan(double propertyValue) {
            this.whereBuilderDelegate.lessThan(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder lessThanOrEqualTo(long propertyValue) {
            this.whereBuilderDelegate.lessThanOrEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder lessThanOrEqualTo(int propertyValue) {
            this.whereBuilderDelegate.lessThanOrEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder lessThanOrEqualTo(double propertyValue) {
            this.whereBuilderDelegate.lessThanOrEqualTo(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder startsWith(String propertyValue) {
            this.whereBuilderDelegate.startsWith(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder startsWithIgnoreCase(String propertyValue) {
            this.whereBuilderDelegate.startsWithIgnoreCase(propertyValue);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder in(String ... values) {
            this.whereBuilderDelegate.in(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder in(int ... values) {
            this.whereBuilderDelegate.in(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder in(long ... values) {
            this.whereBuilderDelegate.in(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder in(double ... values) {
            this.whereBuilderDelegate.in(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder in(boolean ... values) {
            this.whereBuilderDelegate.in(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notIn(String ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notIn(int ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notIn(long ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notIn(double ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder notIn(boolean ... values) {
            this.whereBuilderDelegate.notIn(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsAny(String ... values) {
            this.whereBuilderDelegate.containsAny(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsAny(int ... values) {
            this.whereBuilderDelegate.containsAny(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsAny(long ... values) {
            this.whereBuilderDelegate.containsAny(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsAny(double ... values) {
            this.whereBuilderDelegate.containsAny(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsAll(String ... values) {
            this.whereBuilderDelegate.containsAll(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsAll(int ... values) {
            this.whereBuilderDelegate.containsAll(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsAll(long ... values) {
            this.whereBuilderDelegate.containsAll(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsAll(double ... values) {
            this.whereBuilderDelegate.containsAll(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsNone(String ... values) {
            this.whereBuilderDelegate.containsNone(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsNone(int ... values) {
            this.whereBuilderDelegate.containsNone(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsNone(long ... values) {
            this.whereBuilderDelegate.containsNone(values);
            return ServiceQueryBuilderImpl.this.builder;
        }

        public ServiceQuery.Builder containsNone(double ... values) {
            this.whereBuilderDelegate.containsNone(values);
            return ServiceQueryBuilderImpl.this.builder;
        }
    }
}

