/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201802;

import com.google.api.ads.adwords.axis.utils.v201802.ServiceQueryBuilderImpl;
import com.google.api.ads.adwords.axis.v201802.cm.AdGroupBidLandscape;
import com.google.api.ads.adwords.axis.v201802.cm.AdGroupBidLandscapePage;
import com.google.api.ads.adwords.axis.v201802.cm.CriterionBidLandscape;
import com.google.api.ads.adwords.axis.v201802.cm.CriterionBidLandscapePage;
import com.google.api.ads.adwords.axis.v201802.cm.Page;
import com.google.api.ads.adwords.axis.v201802.cm.SortOrder;
import com.google.api.ads.adwords.lib.selectorfields.EntityField;
import com.google.api.ads.adwords.lib.utils.AdWordsInternals;
import com.google.api.ads.adwords.lib.utils.ServiceQueryInterface;
import com.google.api.ads.common.lib.utils.AdsUtilityInvocationHandler;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import javax.annotation.Nullable;

public final class ServiceQuery
implements ServiceQueryInterface<Page> {
    private final String partialAwqlQuery;
    private final int pageSize;
    private int startIndex;

    ServiceQuery(String partialAwqlQuery, int startIndex, int pageSize) {
        this.partialAwqlQuery = partialAwqlQuery;
        this.startIndex = startIndex;
        this.pageSize = pageSize;
    }

    public ServiceQuery nextPage(@Nullable Page page) {
        return page == null ? this : this.nextPage(this.pageSize);
    }

    public ServiceQuery nextPage(@Nullable AdGroupBidLandscapePage page) {
        if (page == null) {
            return this;
        }
        return this.nextPage(this.getTotalLandscapePointsInPage(page));
    }

    public ServiceQuery nextPage(@Nullable CriterionBidLandscapePage page) {
        if (page == null) {
            return this;
        }
        return this.nextPage(this.getTotalLandscapePointsInPage(page));
    }

    private ServiceQuery nextPage(int pageSize) {
        this.startIndex += pageSize;
        return this;
    }

    public boolean hasNext(@Nullable Page page) {
        return page == null || this.startIndex + this.pageSize < page.getTotalNumEntries();
    }

    public boolean hasNext(@Nullable AdGroupBidLandscapePage page) {
        if (page == null) {
            return true;
        }
        return this.getTotalLandscapePointsInPage(page) >= this.pageSize;
    }

    public boolean hasNext(@Nullable CriterionBidLandscapePage page) {
        if (page == null) {
            return true;
        }
        return this.getTotalLandscapePointsInPage(page) >= this.pageSize;
    }

    public String toString() {
        return String.format("%s LIMIT %s,%s", this.partialAwqlQuery, this.startIndex, this.pageSize);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceQuery) {
            ServiceQuery other = (ServiceQuery)obj;
            return Objects.equal((Object)this.partialAwqlQuery, (Object)other.partialAwqlQuery);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partialAwqlQuery});
    }

    private int getTotalLandscapePointsInPage(AdGroupBidLandscapePage page) {
        if (page.getEntries() == null) {
            return 0;
        }
        int totalLandscapePointsInPage = 0;
        for (AdGroupBidLandscape adGroupBidLandscape : page.getEntries()) {
            totalLandscapePointsInPage += adGroupBidLandscape.getLandscapePoints().length;
        }
        return totalLandscapePointsInPage;
    }

    private int getTotalLandscapePointsInPage(CriterionBidLandscapePage page) {
        if (page.getEntries() == null) {
            return 0;
        }
        int totalLandscapePointsInPage = 0;
        for (CriterionBidLandscape criterionBidLandscape : page.getEntries()) {
            totalLandscapePointsInPage += criterionBidLandscape.getLandscapePoints().length;
        }
        return totalLandscapePointsInPage;
    }

    public static class Builder
    implements ServiceQueryInterface.BuilderInterface<Page, SortOrder> {
        private final ServiceQueryInterface.BuilderInterface<Page, SortOrder> proxy;
        private final ServiceQueryBuilderImpl proxiedImpl;

        public Builder() {
            this.proxiedImpl = new ServiceQueryBuilderImpl(this);
            AdsUtilityInvocationHandler invocationHandler = new AdsUtilityInvocationHandler((Object)this.proxiedImpl, AdWordsInternals.getInstance().getAdsUtilityRegistry());
            this.proxy = (ServiceQueryInterface.BuilderInterface)Reflection.newProxy(ServiceQueryInterface.BuilderInterface.class, (InvocationHandler)invocationHandler);
        }

        public Builder(ServiceQueryInterface.BuilderInterface<Page, SortOrder> builderInterface) {
            Preconditions.checkNotNull(builderInterface, (Object)"The service query builder cannot be null.");
            Builder builder = (Builder)builderInterface;
            this.proxiedImpl = new ServiceQueryBuilderImpl(builder.proxiedImpl);
            AdsUtilityInvocationHandler invocationHandler = new AdsUtilityInvocationHandler((Object)this.proxiedImpl, AdWordsInternals.getInstance().getAdsUtilityRegistry());
            this.proxy = (ServiceQueryInterface.BuilderInterface)Reflection.newProxy(ServiceQueryInterface.BuilderInterface.class, (InvocationHandler)invocationHandler);
        }

        public ServiceQueryInterface.BuilderInterface.ServiceWhereBuilderInterface<Page, SortOrder, Builder> where(EntityField field) {
            return this.proxy.where(field);
        }

        public ServiceQueryInterface.BuilderInterface.ServiceWhereBuilderInterface<Page, SortOrder, Builder> where(String field) {
            return this.proxy.where(field);
        }

        public Builder fields(EntityField ... fields) {
            this.proxy.fields(fields);
            return this;
        }

        public Builder fields(String ... fields) {
            this.proxy.fields(fields);
            return this;
        }

        public Builder fields(Iterable<String> fields) {
            this.proxy.fields(fields);
            return this;
        }

        public ServiceQuery build() {
            return (ServiceQuery)this.proxy.build();
        }

        public Builder orderBy(EntityField field) {
            this.proxy.orderBy(field);
            return this;
        }

        public Builder orderBy(EntityField field, SortOrder order) {
            this.proxy.orderBy(field, (Object)order);
            return this;
        }

        public Builder orderBy(String field) {
            this.proxy.orderBy(field);
            return this;
        }

        public Builder orderBy(String field, SortOrder order) {
            this.proxy.orderBy(field, (Object)order);
            return this;
        }

        public Builder limit(int startIndex, int pageSize) {
            this.proxy.limit(startIndex, pageSize);
            return this;
        }
    }
}

