/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201802.shopping;

import com.google.api.ads.adwords.axis.v201802.cm.ProductBiddingCategory;
import com.google.api.ads.adwords.axis.v201802.cm.ProductBrand;
import com.google.api.ads.adwords.axis.v201802.cm.ProductCanonicalCondition;
import com.google.api.ads.adwords.axis.v201802.cm.ProductCanonicalConditionCondition;
import com.google.api.ads.adwords.axis.v201802.cm.ProductChannel;
import com.google.api.ads.adwords.axis.v201802.cm.ProductChannelExclusivity;
import com.google.api.ads.adwords.axis.v201802.cm.ProductCustomAttribute;
import com.google.api.ads.adwords.axis.v201802.cm.ProductDimension;
import com.google.api.ads.adwords.axis.v201802.cm.ProductDimensionType;
import com.google.api.ads.adwords.axis.v201802.cm.ProductOfferId;
import com.google.api.ads.adwords.axis.v201802.cm.ProductType;
import com.google.api.ads.adwords.axis.v201802.cm.ShoppingProductChannel;
import com.google.api.ads.adwords.axis.v201802.cm.ShoppingProductChannelExclusivity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import javax.annotation.Nullable;

class ProductDimensionComparator
implements Comparator<ProductDimension> {
    private final ImmutableMap<Class<? extends ProductDimension>, Comparator<? extends ProductDimension>> comparatorMap;
    private static final Ordering<Comparable<?>> NULLS_LAST_NATURAL_ORDERING = Ordering.natural().nullsLast();
    private static final Ordering<Object> NULLS_LAST_OBJECT_ORDERING = Ordering.allEqual().nullsLast();
    private static final Ordering<ProductDimensionType> NULLS_LAST_DIMENSION_TYPE_ORDERING = new Ordering<ProductDimensionType>(){

        public int compare(ProductDimensionType left, ProductDimensionType right) {
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)left.getValue(), (Object)right.getValue());
        }
    }.nullsLast();
    private static final Ordering<String> NULLS_LAST_CASE_INSENSITIVE_ORDERING = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast();

    ProductDimensionComparator() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put(ProductBiddingCategory.class, (Object)new ProductBiddingCategoryComparator());
        mapBuilder.put(ProductBrand.class, (Object)new ProductBrandComparator());
        mapBuilder.put(ProductCanonicalCondition.class, (Object)new ProductCanonicalConditionComparator());
        mapBuilder.put(ProductCustomAttribute.class, (Object)new ProductCustomAttributeComparator());
        mapBuilder.put(ProductOfferId.class, (Object)new ProductOfferIdComparator());
        mapBuilder.put(ProductType.class, (Object)new ProductTypeComparator());
        mapBuilder.put(ProductChannel.class, (Object)new ProductChannelComparator());
        mapBuilder.put(ProductChannelExclusivity.class, (Object)new ProductChannelExclusivityComparator());
        this.comparatorMap = mapBuilder.build();
    }

    @Override
    public int compare(@Nullable ProductDimension d1, @Nullable ProductDimension d2) {
        Preconditions.checkArgument((d1 == null || this.comparatorMap.containsKey(d1.getClass()) ? 1 : 0) != 0, (String)"Unsupported dimension type %s", (Object)d1);
        Preconditions.checkArgument((d2 == null || this.comparatorMap.containsKey(d2.getClass()) ? 1 : 0) != 0, (String)"Unsupported dimension type %s", (Object)d2);
        if (d1 == d2) {
            return 0;
        }
        int result = NULLS_LAST_OBJECT_ORDERING.compare((Object)d1, (Object)d2);
        if (result != 0) {
            return result;
        }
        result = d1.getClass().getName().compareTo(d2.getClass().getName());
        if (result != 0) {
            return result;
        }
        Preconditions.checkArgument((boolean)d1.getClass().equals(d2.getClass()), (String)"Assumption failed - class of %s and %s are not equal", (Object)d1, (Object)d2);
        return this.getDeepComparator(d1).compare(d1, d2);
    }

    private <D extends ProductDimension> Comparator<D> getDeepComparator(D dimension) {
        Comparator comparator = (Comparator)this.comparatorMap.get(dimension.getClass());
        Preconditions.checkArgument((comparator != null ? 1 : 0) != 0, (String)"No comparator exists for %s. This comparator only supports comparisons of ProductDimension subclasses supported by Shopping campaigns.", dimension);
        return comparator;
    }

    private static class ProductChannelExclusivityComparator
    implements Comparator<ProductChannelExclusivity> {
        private ProductChannelExclusivityComparator() {
        }

        @Override
        public int compare(ProductChannelExclusivity o1, ProductChannelExclusivity o2) {
            ShoppingProductChannelExclusivity exclusivity2;
            ShoppingProductChannelExclusivity exclusivity1 = o1.getChannelExclusivity();
            if (exclusivity1 == (exclusivity2 = o2.getChannelExclusivity())) {
                return 0;
            }
            int result = NULLS_LAST_OBJECT_ORDERING.compare((Object)exclusivity1, (Object)exclusivity2);
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_NATURAL_ORDERING.compare((Object)exclusivity1.getValue(), (Object)exclusivity2.getValue());
        }
    }

    private static class ProductChannelComparator
    implements Comparator<ProductChannel> {
        private ProductChannelComparator() {
        }

        @Override
        public int compare(ProductChannel o1, ProductChannel o2) {
            ShoppingProductChannel channel2;
            ShoppingProductChannel channel1 = o1.getChannel();
            if (channel1 == (channel2 = o2.getChannel())) {
                return 0;
            }
            int result = NULLS_LAST_OBJECT_ORDERING.compare((Object)channel1, (Object)channel2);
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_NATURAL_ORDERING.compare((Object)channel1.getValue(), (Object)channel2.getValue());
        }
    }

    private static class ProductTypeComparator
    implements Comparator<ProductType> {
        private ProductTypeComparator() {
        }

        @Override
        public int compare(ProductType o1, ProductType o2) {
            int result = NULLS_LAST_DIMENSION_TYPE_ORDERING.compare((Object)o1.getType(), (Object)o2.getType());
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    private static class ProductOfferIdComparator
    implements Comparator<ProductOfferId> {
        private ProductOfferIdComparator() {
        }

        @Override
        public int compare(ProductOfferId o1, ProductOfferId o2) {
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    private static class ProductCustomAttributeComparator
    implements Comparator<ProductCustomAttribute> {
        private ProductCustomAttributeComparator() {
        }

        @Override
        public int compare(ProductCustomAttribute o1, ProductCustomAttribute o2) {
            int result = NULLS_LAST_DIMENSION_TYPE_ORDERING.compare((Object)o1.getType(), (Object)o2.getType());
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    private static class ProductCanonicalConditionComparator
    implements Comparator<ProductCanonicalCondition> {
        private ProductCanonicalConditionComparator() {
        }

        @Override
        public int compare(ProductCanonicalCondition o1, ProductCanonicalCondition o2) {
            ProductCanonicalConditionCondition condition2;
            ProductCanonicalConditionCondition condition1 = o1.getCondition();
            if (condition1 == (condition2 = o2.getCondition())) {
                return 0;
            }
            int result = NULLS_LAST_OBJECT_ORDERING.compare((Object)condition1, (Object)condition2);
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_NATURAL_ORDERING.compare((Object)condition1.getValue(), (Object)condition2.getValue());
        }
    }

    private static class ProductBrandComparator
    implements Comparator<ProductBrand> {
        private ProductBrandComparator() {
        }

        @Override
        public int compare(ProductBrand o1, ProductBrand o2) {
            return NULLS_LAST_CASE_INSENSITIVE_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }

    private static class ProductBiddingCategoryComparator
    implements Comparator<ProductBiddingCategory> {
        private ProductBiddingCategoryComparator() {
        }

        @Override
        public int compare(ProductBiddingCategory o1, ProductBiddingCategory o2) {
            int result = NULLS_LAST_DIMENSION_TYPE_ORDERING.compare((Object)o1.getType(), (Object)o2.getType());
            if (result != 0) {
                return result;
            }
            return NULLS_LAST_NATURAL_ORDERING.compare((Object)o1.getValue(), (Object)o2.getValue());
        }
    }
}

