/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils;

import com.google.api.ads.adwords.axis.utils.AxisSerializer;
import com.google.api.ads.adwords.lib.utils.BatchJobException;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateRequestInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadBodyProvider;
import com.google.api.client.http.ByteArrayContent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.io.StringWriter;
import java.util.SortedSet;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.xml.sax.Attributes;

public class AxisBatchJobUploadBodyProvider
implements BatchJobUploadBodyProvider {
    private final SortedSet<String> namespaceUris;

    public AxisBatchJobUploadBodyProvider(Iterable<String> namespaceUris) {
        this.namespaceUris = ImmutableSortedSet.copyOf(namespaceUris);
    }

    public ByteArrayContent getHttpContent(BatchJobMutateRequestInterface request, boolean isFirstRequest, boolean isLastRequest) throws BatchJobException {
        Preconditions.checkNotNull((Object)request, (Object)"Null request");
        StringWriter writer = new StringWriter();
        SerializationContext context = new SerializationContext(writer){

            public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType, Class javaType) throws IOException {
                super.serialize(elemQName, attributes, value, xmlType, javaType, Boolean.valueOf(false), null);
            }
        };
        context.setSendDecl(false);
        context.setPretty(true);
        int namespaceIndex = 0;
        for (String namespaceUri : this.namespaceUris) {
            context.registerPrefixForURI(String.format("ns%d", namespaceIndex++), namespaceUri);
        }
        AxisSerializer serializer = new AxisSerializer();
        serializer.serialize(request, context);
        return new ByteArrayContent("application/xml", writer.toString().getBytes());
    }
}

