/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils;

import com.google.api.ads.adwords.axis.utils.AxisSerializer;
import com.google.api.ads.adwords.lib.utils.BatchJobException;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateRequestInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadBodyProvider;
import com.google.api.client.http.ByteArrayContent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.io.StringWriter;
import java.util.SortedSet;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.xml.sax.Attributes;

public class AxisBatchJobUploadBodyProvider
implements BatchJobUploadBodyProvider {
    private final SortedSet<String> namespaceUris;
    private static final int REQUIRED_CONTENT_LENGTH_INCREMENT = 262144;

    public AxisBatchJobUploadBodyProvider(Iterable<String> namespaceUris) {
        this.namespaceUris = ImmutableSortedSet.copyOf(namespaceUris);
    }

    public ByteArrayContent getHttpContent(BatchJobMutateRequestInterface request, boolean isFirstRequest, boolean isLastRequest) throws BatchJobException {
        int numBytes;
        int remainder;
        Preconditions.checkNotNull((Object)request, (Object)"Null request");
        StringWriter writer = new StringWriter();
        SerializationContext context = new SerializationContext(writer){

            public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType, Class javaType) throws IOException {
                super.serialize(elemQName, attributes, value, xmlType, javaType, Boolean.valueOf(false), null);
            }
        };
        context.setSendDecl(false);
        context.setPretty(true);
        int namespaceIndex = 0;
        for (String namespaceUri : this.namespaceUris) {
            context.registerPrefixForURI(String.format("ns%d", namespaceIndex++), namespaceUri);
        }
        AxisSerializer serializer = new AxisSerializer();
        serializer.serialize(request, context);
        String serializedRequest = this.trimStartEndElements(writer.toString(), isFirstRequest, isLastRequest);
        if (!(isFirstRequest && isLastRequest || (remainder = (numBytes = serializedRequest.getBytes().length) % 262144) <= 0)) {
            int pad = 262144 - remainder;
            serializedRequest = Strings.padEnd((String)serializedRequest, (int)(numBytes + pad), (char)' ');
        }
        return new ByteArrayContent("application/xml", serializedRequest.getBytes());
    }

    @VisibleForTesting
    String trimStartEndElements(String serializedRequest, boolean isFirstRequest, boolean isLastRequest) {
        int beginIndex = 0;
        int endIndex = serializedRequest.length();
        if (!isFirstRequest) {
            beginIndex = serializedRequest.indexOf(62) + 1;
        }
        if (!isLastRequest) {
            endIndex = serializedRequest.lastIndexOf(60);
        }
        return serializedRequest.substring(beginIndex, endIndex);
    }
}

