/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201509.batchjob;

import com.google.api.ads.adwords.axis.utils.AxisDeserializer;
import com.google.api.ads.adwords.axis.utils.v201509.batchjob.BatchJobMutateRequest;
import com.google.api.ads.adwords.axis.utils.v201509.batchjob.BatchJobMutateResponse;
import com.google.api.ads.adwords.axis.utils.v201509.batchjob.MutateResult;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupAdServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupBidModifierServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupCriterionServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201509.cm.ApiError;
import com.google.api.ads.adwords.axis.v201509.cm.BudgetServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201509.cm.CampaignCriterionServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201509.cm.CampaignServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201509.cm.FeedItemServiceSoapBindingStub;
import com.google.api.ads.adwords.axis.v201509.cm.Operand;
import com.google.api.ads.adwords.axis.v201509.cm.Operation;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.BatchJobException;
import com.google.api.ads.adwords.lib.utils.BatchJobHelperInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateRequestInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadResponse;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadStatus;
import com.google.api.ads.adwords.lib.utils.BatchJobUploader;
import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.TypeMapping;

public class BatchJobHelper
implements BatchJobHelperInterface<Operation, Operand, ApiError, MutateResult, BatchJobMutateResponse> {
    private BatchJobUploader<Operand, ApiError, MutateResult, BatchJobMutateResponse> uploader;
    private final QName resultQName;
    private final QName operandQName;
    private static final AtomicReference<ImmutableList<TypeMapping>> SERVICE_TYPE_MAPPINGS_REF = new AtomicReference();

    public BatchJobHelper(AdWordsSession session) {
        this.uploader = new BatchJobUploader(session);
        this.resultQName = new QName("https://adwords.google.com/api/adwords/cm/v201509", "MutateResult");
        this.operandQName = new QName("https://adwords.google.com/api/adwords/cm/v201509", "Operand");
    }

    public BatchJobUploadResponse uploadBatchJobOperations(Iterable<Operation> operations, String uploadUrl) throws BatchJobException {
        BatchJobMutateRequest request = new BatchJobMutateRequest();
        request.addOperations(operations);
        return this.uploader.uploadBatchJobOperations((BatchJobMutateRequestInterface)request, uploadUrl);
    }

    public BatchJobUploadResponse uploadIncrementalBatchJobOperations(Iterable<? extends Operation> operations, boolean isLastRequest, BatchJobUploadStatus batchJobUploadStatus) throws BatchJobException {
        BatchJobMutateRequest request = new BatchJobMutateRequest();
        request.addOperations(operations);
        return this.uploader.uploadIncrementalBatchJobOperations((BatchJobMutateRequestInterface)request, isLastRequest, batchJobUploadStatus);
    }

    public BatchJobMutateResponse downloadBatchJobMutateResponse(String downloadUrl) throws BatchJobException {
        List<MutateResult> mutateResults;
        AxisDeserializer deserializer = new AxisDeserializer();
        try {
            mutateResults = deserializer.deserializeBatchJobMutateResults(new URL(downloadUrl), BatchJobHelper.getServiceTypeMappings(), MutateResult.class, this.resultQName, Operand.class, this.operandQName);
        }
        catch (Exception e) {
            String string = String.valueOf(downloadUrl);
            throw new BatchJobException(string.length() != 0 ? "Failed to download batch job mutate response from URL: ".concat(string) : new String("Failed to download batch job mutate response from URL: "), (Throwable)e);
        }
        BatchJobMutateResponse response = new BatchJobMutateResponse();
        response.setMutateResults(mutateResults.toArray(new MutateResult[mutateResults.size()]));
        return response;
    }

    private static List<TypeMapping> getServiceTypeMappings() {
        if (SERVICE_TYPE_MAPPINGS_REF.get() == null) {
            ImmutableList.Builder mappings = ImmutableList.builder();
            try {
                mappings.add((Object)new AdGroupAdServiceSoapBindingStub(){

                    public Call _createCall() throws ServiceException {
                        try {
                            return super.createCall();
                        }
                        catch (RemoteException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }._createCall().getTypeMapping());
                mappings.add((Object)new AdGroupBidModifierServiceSoapBindingStub(){

                    public Call _createCall() throws ServiceException {
                        try {
                            return super.createCall();
                        }
                        catch (RemoteException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }._createCall().getTypeMapping());
                mappings.add((Object)new AdGroupCriterionServiceSoapBindingStub(){

                    public Call _createCall() throws ServiceException {
                        try {
                            return super.createCall();
                        }
                        catch (RemoteException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }._createCall().getTypeMapping());
                mappings.add((Object)new AdGroupServiceSoapBindingStub(){

                    public Call _createCall() throws ServiceException {
                        try {
                            return super.createCall();
                        }
                        catch (RemoteException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }._createCall().getTypeMapping());
                mappings.add((Object)new BudgetServiceSoapBindingStub(){

                    public Call _createCall() throws ServiceException {
                        try {
                            return super.createCall();
                        }
                        catch (RemoteException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }._createCall().getTypeMapping());
                mappings.add((Object)new CampaignCriterionServiceSoapBindingStub(){

                    public Call _createCall() throws ServiceException {
                        try {
                            return super.createCall();
                        }
                        catch (RemoteException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }._createCall().getTypeMapping());
                mappings.add((Object)new CampaignServiceSoapBindingStub(){

                    public Call _createCall() throws ServiceException {
                        try {
                            return super.createCall();
                        }
                        catch (RemoteException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }._createCall().getTypeMapping());
                mappings.add((Object)new FeedItemServiceSoapBindingStub(){

                    public Call _createCall() throws ServiceException {
                        try {
                            return super.createCall();
                        }
                        catch (RemoteException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }._createCall().getTypeMapping());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize service type mappings", e);
            }
            SERVICE_TYPE_MAPPINGS_REF.compareAndSet(null, (ImmutableList<TypeMapping>)mappings.build());
        }
        return (List)SERVICE_TYPE_MAPPINGS_REF.get();
    }
}

